/*
 * Decompiled with CFR 0.152.
 */
package cloud.genesys.webmessaging.sdk.model;

import cloud.genesys.webmessaging.sdk.model.Action;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Quick reply content.  Quick reply object.")
public class ContentQuickReply
implements Serializable {
    private Action action = null;
    private String id = null;
    private String image = null;
    private String payload = null;
    private String text = null;

    public ContentQuickReply action(Action action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies the type of action that is triggered upon clicking the quick reply.")
    @JsonProperty(value="action")
    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public ContentQuickReply id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="A unique ID assigned to the quick reply (Deprecated).")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ContentQuickReply image(String image) {
        this.image = image;
        return this;
    }

    @ApiModelProperty(example="null", value="URL of an image associated with the quick reply.")
    @JsonProperty(value="image")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public ContentQuickReply payload(String payload) {
        this.payload = payload;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Content of the payload included in the quick reply response. Could be an ID identifying the quick reply response.")
    @JsonProperty(value="payload")
    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public ContentQuickReply text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Text to show inside the quick reply. This is also used as the response text after clicking on the quick reply.")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentQuickReply contentQuickReply = (ContentQuickReply)o;
        return Objects.equals((Object)this.action, (Object)contentQuickReply.action) && Objects.equals(this.id, contentQuickReply.id) && Objects.equals(this.image, contentQuickReply.image) && Objects.equals(this.payload, contentQuickReply.payload) && Objects.equals(this.text, contentQuickReply.text);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.id, this.image, this.payload, this.text});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContentQuickReply {\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

