/*
 * Decompiled with CFR 0.152.
 */
package cloud.genesys.webmessaging.sdk.connector.apache;

import cloud.genesys.webmessaging.sdk.connector.ApiClientConnector;
import cloud.genesys.webmessaging.sdk.connector.ApiClientConnectorRequest;
import cloud.genesys.webmessaging.sdk.connector.ApiClientConnectorResponse;
import cloud.genesys.webmessaging.sdk.connector.apache.ApacheHttpResponse;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class ApacheHttpClientConnector
implements ApiClientConnector {
    private final CloseableHttpClient client;
    private final ExecutorService executorService;

    public ApacheHttpClientConnector(CloseableHttpClient client, ExecutorService executorService) {
        this.client = client;
        this.executorService = executorService;
    }

    @Override
    public ApiClientConnectorResponse invoke(ApiClientConnectorRequest request) throws IOException {
        Object httpUriRequest;
        Object req;
        String method = request.getMethod();
        String url = request.getUrl();
        String body = request.readBody();
        if ("GET".equals(method)) {
            req = new HttpGet(url);
            httpUriRequest = req;
        } else if ("HEAD".equals(method)) {
            req = new HttpHead(url);
            httpUriRequest = req;
        } else if ("POST".equals(method)) {
            req = new HttpPost(url);
            if (body != null) {
                req.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
            }
            httpUriRequest = req;
        } else if ("PUT".equals(method)) {
            req = new HttpPut(url);
            if (body != null) {
                req.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
            }
            httpUriRequest = req;
        } else if ("DELETE".equals(method)) {
            req = new HttpDelete(url);
            httpUriRequest = req;
        } else if ("PATCH".equals(method)) {
            req = new HttpPatch(url);
            if (body != null) {
                req.setEntity((HttpEntity)new StringEntity(body, "UTF-8"));
            }
            httpUriRequest = req;
        } else {
            throw new IllegalStateException("Unknown method type " + method);
        }
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            httpUriRequest.setHeader((String)entry.getKey(), (String)entry.getValue());
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)httpUriRequest);
        return new ApacheHttpResponse(response);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

