package cloud.genesys.webmessaging.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.util.Objects;
import java.io.IOException;
import cloud.genesys.webmessaging.sdk.model.ContentActions;
import cloud.genesys.webmessaging.sdk.model.ListItemType;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
/**
 * An entry in a List template.
 */
@ApiModel(description = "An entry in a List template.")

public class ListItemComponent  implements Serializable {
  
  private ContentActions actions = null;
  private String description = null;
  private String id = null;
  private String image = null;
  private String rmid = null;
  private String title = null;
  private ListItemType type = null;

  
  /**
   * The list item actions (Deprecated).
   **/
  public ListItemComponent actions(ContentActions actions) {
    this.actions = actions;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "The list item actions (Deprecated).")
  @JsonProperty("actions")
  public ContentActions getActions() {
    return actions;
  }
  public void setActions(ContentActions actions) {
    this.actions = actions;
  }


  /**
   * Text to show in the list item description.
   **/
  public ListItemComponent description(String description) {
    this.description = description;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "Text to show in the list item description.")
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }
  public void setDescription(String description) {
    this.description = description;
  }


  /**
   * An ID assigned to this list item.
   **/
  public ListItemComponent id(String id) {
    this.id = id;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "An ID assigned to this list item.")
  @JsonProperty("id")
  public String getId() {
    return id;
  }
  public void setId(String id) {
    this.id = id;
  }


  /**
   * URL of an image.
   **/
  public ListItemComponent image(String image) {
    this.image = image;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "URL of an image.")
  @JsonProperty("image")
  public String getImage() {
    return image;
  }
  public void setImage(String image) {
    this.image = image;
  }


  /**
   * An ID of the rich message instance.
   **/
  public ListItemComponent rmid(String rmid) {
    this.rmid = rmid;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "An ID of the rich message instance.")
  @JsonProperty("rmid")
  public String getRmid() {
    return rmid;
  }
  public void setRmid(String rmid) {
    this.rmid = rmid;
  }


  /**
   * The main headline of the list item.
   **/
  public ListItemComponent title(String title) {
    this.title = title;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "The main headline of the list item.")
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }
  public void setTitle(String title) {
    this.title = title;
  }


  /**
   * The type of list item to render.
   **/
  public ListItemComponent type(ListItemType type) {
    this.type = type;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "The type of list item to render.")
  @JsonProperty("type")
  public ListItemType getType() {
    return type;
  }
  public void setType(ListItemType type) {
    this.type = type;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ListItemComponent listItemComponent = (ListItemComponent) o;
    return Objects.equals(this.actions, listItemComponent.actions) &&
          Objects.equals(this.description, listItemComponent.description) &&
          Objects.equals(this.id, listItemComponent.id) &&
          Objects.equals(this.image, listItemComponent.image) &&
          Objects.equals(this.rmid, listItemComponent.rmid) &&
          Objects.equals(this.title, listItemComponent.title) &&
          Objects.equals(this.type, listItemComponent.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(actions, description, id, image, rmid, title, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ListItemComponent {\n");
    
    sb.append("    actions: ").append(toIndentedString(actions)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    image: ").append(toIndentedString(image)).append("\n");
    sb.append("    rmid: ").append(toIndentedString(rmid)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

