/*
 * Decompiled with CFR 0.152.
 */
package cloud.genesys.webmessaging.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Attachment object.")
public class WebMessagingAttachment
implements Serializable {
    private String id = null;
    private MediaTypeEnum mediaType = null;
    private String url = null;
    private String mime = null;
    private String text = null;
    private String sha256 = null;
    private String filename = null;
    private Integer fileSize = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The type of attachment this instance represents.")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    @ApiModelProperty(example="null", value="URL of the attachment.")
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @ApiModelProperty(example="null", value="Attachment mime type (https://www.iana.org/assignments/media-types/media-types.xhtml).")
    @JsonProperty(value="mime")
    public String getMime() {
        return this.mime;
    }

    @ApiModelProperty(example="null", value="Text associated with attachment such as an image caption.")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @ApiModelProperty(example="null", value="Secure hash of the attachment content.")
    @JsonProperty(value="sha256")
    public String getSha256() {
        return this.sha256;
    }

    @ApiModelProperty(example="null", value="Suggested file name for attachment.")
    @JsonProperty(value="filename")
    public String getFilename() {
        return this.filename;
    }

    @ApiModelProperty(example="null", value="The file size associated with the file")
    @JsonProperty(value="fileSize")
    public Integer getFileSize() {
        return this.fileSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebMessagingAttachment webMessagingAttachment = (WebMessagingAttachment)o;
        return Objects.equals(this.id, webMessagingAttachment.id) && Objects.equals((Object)this.mediaType, (Object)webMessagingAttachment.mediaType) && Objects.equals(this.url, webMessagingAttachment.url) && Objects.equals(this.mime, webMessagingAttachment.mime) && Objects.equals(this.text, webMessagingAttachment.text) && Objects.equals(this.sha256, webMessagingAttachment.sha256) && Objects.equals(this.filename, webMessagingAttachment.filename) && Objects.equals(this.fileSize, webMessagingAttachment.fileSize);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.mediaType, this.url, this.mime, this.text, this.sha256, this.filename, this.fileSize});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebMessagingAttachment {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    mime: ").append(this.toIndentedString(this.mime)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    sha256: ").append(this.toIndentedString(this.sha256)).append("\n");
        sb.append("    filename: ").append(this.toIndentedString(this.filename)).append("\n");
        sb.append("    fileSize: ").append(this.toIndentedString(this.fileSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        IMAGE("Image"),
        VIDEO("Video"),
        AUDIO("Audio"),
        FILE("File");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

