/*
 * Decompiled with CFR 0.152.
 */
package cloud.genesys.webmessaging.sdk.model;

import cloud.genesys.webmessaging.sdk.model.MediaTypeDeserializer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

@JsonDeserialize(using=MediaTypeDeserializer.class)
public enum MediaType {
    AUDIO("Audio"),
    FILE("File"),
    IMAGE("Image"),
    LINK("Link"),
    VIDEO("Video");

    private String value;

    private MediaType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static MediaType fromString(String key) {
        if (key == null) {
            return null;
        }
        for (MediaType value : MediaType.values()) {
            if (!key.equalsIgnoreCase(value.toString())) continue;
            return value;
        }
        return MediaType.values()[0];
    }

    @JsonValue
    public String toString() {
        return String.valueOf(this.value);
    }
}

