/*
 * Decompiled with CFR 0.152.
 */
package cloud.genesys.webmessaging.sdk.model;

import cloud.genesys.webmessaging.sdk.model.ContentTypeDeserializer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

@JsonDeserialize(using=ContentTypeDeserializer.class)
public enum ContentType {
    ATTACHMENT("Attachment"),
    BUTTONRESPONSE("ButtonResponse"),
    CARD("Card"),
    CAROUSEL("Carousel"),
    GENERICTEMPLATE("GenericTemplate"),
    LISTTEMPLATE("ListTemplate"),
    LOCATION("Location"),
    MENTION("Mention"),
    NOTIFICATION("Notification"),
    POSTBACK("Postback"),
    QUICKREPLY("QuickReply"),
    REACTIONS("Reactions"),
    STORY("Story");

    private String value;

    private ContentType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static ContentType fromString(String key) {
        if (key == null) {
            return null;
        }
        for (ContentType value : ContentType.values()) {
            if (!key.equalsIgnoreCase(value.toString())) continue;
            return value;
        }
        return ContentType.values()[0];
    }

    @JsonValue
    public String toString() {
        return String.valueOf(this.value);
    }
}

