/*
 * Decompiled with CFR 0.152.
 */
package cloud.genesys.webmessaging.sdk.model;

import cloud.genesys.webmessaging.sdk.model.CardAction;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Card content  Card content object.")
public class ContentCard
implements Serializable {
    private List<CardAction> actions = new ArrayList<CardAction>();
    private CardAction defaultAction = null;
    private String description = null;
    private String image = null;
    private String title = null;
    private String video = null;

    public ContentCard actions(List<CardAction> actions) {
        this.actions = actions;
        return this;
    }

    @ApiModelProperty(example="null", value="An array of action objects.")
    @JsonProperty(value="actions")
    public List<CardAction> getActions() {
        return this.actions;
    }

    public void setActions(List<CardAction> actions) {
        this.actions = actions;
    }

    public ContentCard defaultAction(CardAction defaultAction) {
        this.defaultAction = defaultAction;
        return this;
    }

    @ApiModelProperty(example="null", value="The  Default button action.")
    @JsonProperty(value="defaultAction")
    public CardAction getDefaultAction() {
        return this.defaultAction;
    }

    public void setDefaultAction(CardAction defaultAction) {
        this.defaultAction = defaultAction;
    }

    public ContentCard description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="Text to show in the description.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ContentCard image(String image) {
        this.image = image;
        return this;
    }

    @ApiModelProperty(example="null", value="URL of an image.")
    @JsonProperty(value="image")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public ContentCard title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="null", value="Text to show in the title.")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ContentCard video(String video) {
        this.video = video;
        return this;
    }

    @ApiModelProperty(example="null", value="URL of a video.")
    @JsonProperty(value="video")
    public String getVideo() {
        return this.video;
    }

    public void setVideo(String video) {
        this.video = video;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentCard contentCard = (ContentCard)o;
        return Objects.equals(this.actions, contentCard.actions) && Objects.equals(this.defaultAction, contentCard.defaultAction) && Objects.equals(this.description, contentCard.description) && Objects.equals(this.image, contentCard.image) && Objects.equals(this.title, contentCard.title) && Objects.equals(this.video, contentCard.video);
    }

    public int hashCode() {
        return Objects.hash(this.actions, this.defaultAction, this.description, this.image, this.title, this.video);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContentCard {\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    defaultAction: ").append(this.toIndentedString(this.defaultAction)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    video: ").append(this.toIndentedString(this.video)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

