/*
 * Decompiled with CFR 0.152.
 */
package cloud.genesys.webmessaging.sdk.model;

import cloud.genesys.webmessaging.sdk.model.CardActionType;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="A card action that a user can take.  The  Default button action.")
public class CardAction
implements Serializable {
    private String payload = null;
    private String text = null;
    private CardActionType type = null;
    private String url = null;

    public CardAction payload(String payload) {
        this.payload = payload;
        return this;
    }

    @ApiModelProperty(example="null", value="Text to be returned as the payload from a ButtonResponse when a button is clicked. The payload and text are a combination which will have to be unique across each card and carousel in order to determine which button was clicked in that card or carousel.")
    @JsonProperty(value="payload")
    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public CardAction text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", value="The response text from the button click.")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public CardAction type(CardActionType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="Describes the type of action.")
    @JsonProperty(value="type")
    public CardActionType getType() {
        return this.type;
    }

    public void setType(CardActionType type) {
        this.type = type;
    }

    public CardAction url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="null", value="A URL of a web page to direct the user to.")
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardAction cardAction = (CardAction)o;
        return Objects.equals(this.payload, cardAction.payload) && Objects.equals(this.text, cardAction.text) && Objects.equals((Object)this.type, (Object)cardAction.type) && Objects.equals(this.url, cardAction.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.payload, this.text, this.type, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CardAction {\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

