/*
 * Decompiled with CFR 0.152.
 */
package cloud.genesys.webmessaging.sdk.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Information about the recipient the message is sent to or received from.")
public class WebMessagingRecipient
implements Serializable {
    private String firstName = null;
    private String lastName = null;
    private String nickname = null;

    @ApiModelProperty(example="null", value="First name of the recipient.")
    @JsonProperty(value="firstName")
    public String getFirstName() {
        return this.firstName;
    }

    @ApiModelProperty(example="null", value="Last name of the recipient.")
    @JsonProperty(value="lastName")
    public String getLastName() {
        return this.lastName;
    }

    @ApiModelProperty(example="null", value="Nickname or display name of the recipient.")
    @JsonProperty(value="nickname")
    public String getNickname() {
        return this.nickname;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebMessagingRecipient webMessagingRecipient = (WebMessagingRecipient)o;
        return Objects.equals(this.firstName, webMessagingRecipient.firstName) && Objects.equals(this.lastName, webMessagingRecipient.lastName) && Objects.equals(this.nickname, webMessagingRecipient.nickname);
    }

    public int hashCode() {
        return Objects.hash(this.firstName, this.lastName, this.nickname);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebMessagingRecipient {\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    nickname: ").append(this.toIndentedString(this.nickname)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

