/*
 * Decompiled with CFR 0.152.
 */
package cloud.genesys.webmessaging.sdk.model;

import cloud.genesys.webmessaging.sdk.model.IDType;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Information about the recipient the message is received from.  Information about the recipient the message is sent to or received from.  Information about the recipient the message is sent to.  Mention content.")
public class MessagingRecipient
implements Serializable {
    private String email = null;
    private String firstName = null;
    private String id = null;
    private IDType idType = null;
    private String image = null;
    private String lastName = null;
    private String nickname = null;

    public MessagingRecipient email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(example="null", value="E-mail address of the recipient.")
    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public MessagingRecipient firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(example="null", value="First name of the recipient.")
    @JsonProperty(value="firstName")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public MessagingRecipient id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The recipient ID specific to the provider.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MessagingRecipient idType(IDType idType) {
        this.idType = idType;
        return this;
    }

    @ApiModelProperty(example="null", value="The recipient ID type. This is used to indicate the format used for the ID.")
    @JsonProperty(value="idType")
    public IDType getIdType() {
        return this.idType;
    }

    public void setIdType(IDType idType) {
        this.idType = idType;
    }

    public MessagingRecipient image(String image) {
        this.image = image;
        return this;
    }

    @ApiModelProperty(example="null", value="URL of an image that represents the recipient.")
    @JsonProperty(value="image")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public MessagingRecipient lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(example="null", value="Last name of the recipient.")
    @JsonProperty(value="lastName")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public MessagingRecipient nickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    @ApiModelProperty(example="null", value="Nickname or display name of the recipient.")
    @JsonProperty(value="nickname")
    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagingRecipient messagingRecipient = (MessagingRecipient)o;
        return Objects.equals(this.email, messagingRecipient.email) && Objects.equals(this.firstName, messagingRecipient.firstName) && Objects.equals(this.id, messagingRecipient.id) && Objects.equals((Object)this.idType, (Object)messagingRecipient.idType) && Objects.equals(this.image, messagingRecipient.image) && Objects.equals(this.lastName, messagingRecipient.lastName) && Objects.equals(this.nickname, messagingRecipient.nickname);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.email, this.firstName, this.id, this.idType, this.image, this.lastName, this.nickname});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessagingRecipient {\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    idType: ").append(this.toIndentedString((Object)this.idType)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    nickname: ").append(this.toIndentedString(this.nickname)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

