/*
 * Decompiled with CFR 0.152.
 */
package cloud.genesys.webmessaging.sdk.api;

import cloud.genesys.webmessaging.sdk.ApiClient;
import cloud.genesys.webmessaging.sdk.ApiRequest;
import cloud.genesys.webmessaging.sdk.ApiResponse;
import cloud.genesys.webmessaging.sdk.Configuration;
import cloud.genesys.webmessaging.sdk.WebMessagingException;
import cloud.genesys.webmessaging.sdk.api.request.GetWebmessagingMessagesRequest;
import cloud.genesys.webmessaging.sdk.model.WebMessagingMessageEntityList;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;

public class WebMessagingApi {
    private final ApiClient gcapiClient;

    public WebMessagingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WebMessagingApi(ApiClient apiClient) {
        this.gcapiClient = apiClient;
    }

    public WebMessagingMessageEntityList getWebmessagingMessages(Integer pageSize, Integer pageNumber) throws IOException, WebMessagingException {
        return this.getWebmessagingMessages(this.createGetWebmessagingMessagesRequest(pageSize, pageNumber));
    }

    public ApiResponse<WebMessagingMessageEntityList> getWebmessagingMessagesWithHttpInfo(Integer pageSize, Integer pageNumber) throws IOException {
        return this.getWebmessagingMessages(this.createGetWebmessagingMessagesRequest(pageSize, pageNumber).withHttpInfo());
    }

    private GetWebmessagingMessagesRequest createGetWebmessagingMessagesRequest(Integer pageSize, Integer pageNumber) {
        return GetWebmessagingMessagesRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).build();
    }

    public WebMessagingMessageEntityList getWebmessagingMessages(GetWebmessagingMessagesRequest request) throws IOException, WebMessagingException {
        try {
            ApiResponse<WebMessagingMessageEntityList> response = this.gcapiClient.invoke(request.withHttpInfo(), new TypeReference<WebMessagingMessageEntityList>(){});
            return response.getBody();
        }
        catch (WebMessagingException | IOException exception) {
            if (this.gcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WebMessagingMessageEntityList> getWebmessagingMessages(ApiRequest<Void> request) throws IOException {
        try {
            return this.gcapiClient.invoke(request, new TypeReference<WebMessagingMessageEntityList>(){});
        }
        catch (WebMessagingException exception) {
            ApiResponse response = (ApiResponse)((Object)exception);
            return response;
        }
        catch (Throwable exception) {
            if (this.gcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiResponse response = (ApiResponse)((Object)new WebMessagingException(exception));
            return response;
        }
    }
}

