/*
 * Decompiled with CFR 0.152.
 */
package cloud.genesys.webmessaging.sdk.model;

import cloud.genesys.webmessaging.sdk.model.WebMessagingAttachment;
import cloud.genesys.webmessaging.sdk.model.WebMessagingButtonResponse;
import cloud.genesys.webmessaging.sdk.model.WebMessagingGeneric;
import cloud.genesys.webmessaging.sdk.model.WebMessagingQuickReply;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Message content element.")
public class WebMessagingContent
implements Serializable {
    private ContentTypeEnum contentType = null;
    private WebMessagingAttachment attachment = null;
    private WebMessagingQuickReply quickReply = null;
    private WebMessagingButtonResponse buttonResponse = null;
    private WebMessagingGeneric generic = null;

    @ApiModelProperty(example="null", value="Type of this content element. If contentType = \"Attachment\" only one item is allowed.")
    @JsonProperty(value="contentType")
    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    @ApiModelProperty(example="null", value="Attachment content.")
    @JsonProperty(value="attachment")
    public WebMessagingAttachment getAttachment() {
        return this.attachment;
    }

    public WebMessagingContent quickReply(WebMessagingQuickReply quickReply) {
        this.quickReply = quickReply;
        return this;
    }

    @ApiModelProperty(example="null", value="Quick reply content.")
    @JsonProperty(value="quickReply")
    public WebMessagingQuickReply getQuickReply() {
        return this.quickReply;
    }

    public void setQuickReply(WebMessagingQuickReply quickReply) {
        this.quickReply = quickReply;
    }

    public WebMessagingContent buttonResponse(WebMessagingButtonResponse buttonResponse) {
        this.buttonResponse = buttonResponse;
        return this;
    }

    @ApiModelProperty(example="null", value="Button response content.")
    @JsonProperty(value="buttonResponse")
    public WebMessagingButtonResponse getButtonResponse() {
        return this.buttonResponse;
    }

    public void setButtonResponse(WebMessagingButtonResponse buttonResponse) {
        this.buttonResponse = buttonResponse;
    }

    public WebMessagingContent generic(WebMessagingGeneric generic) {
        this.generic = generic;
        return this;
    }

    @ApiModelProperty(example="null", value="Generic content.")
    @JsonProperty(value="generic")
    public WebMessagingGeneric getGeneric() {
        return this.generic;
    }

    public void setGeneric(WebMessagingGeneric generic) {
        this.generic = generic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebMessagingContent webMessagingContent = (WebMessagingContent)o;
        return Objects.equals((Object)this.contentType, (Object)webMessagingContent.contentType) && Objects.equals(this.attachment, webMessagingContent.attachment) && Objects.equals(this.quickReply, webMessagingContent.quickReply) && Objects.equals(this.buttonResponse, webMessagingContent.buttonResponse) && Objects.equals(this.generic, webMessagingContent.generic);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contentType, this.attachment, this.quickReply, this.buttonResponse, this.generic});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebMessagingContent {\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    quickReply: ").append(this.toIndentedString(this.quickReply)).append("\n");
        sb.append("    buttonResponse: ").append(this.toIndentedString(this.buttonResponse)).append("\n");
        sb.append("    generic: ").append(this.toIndentedString(this.generic)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ContentTypeEnumDeserializer.class)
    public static enum ContentTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ATTACHMENT("Attachment"),
        QUICKREPLY("QuickReply"),
        BUTTONRESPONSE("ButtonResponse"),
        GENERICTEMPLATE("GenericTemplate");

        private String value;

        private ContentTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ContentTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ContentTypeEnum value : ContentTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ContentTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ContentTypeEnumDeserializer
    extends StdDeserializer<ContentTypeEnum> {
        public ContentTypeEnumDeserializer() {
            super(ContentTypeEnumDeserializer.class);
        }

        public ContentTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ContentTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

