/*
 * Decompiled with CFR 0.152.
 */
package cloud.genesys.webmessaging.sdk.model;

import cloud.genesys.webmessaging.sdk.model.MessageDataTypeDeserializer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

@JsonDeserialize(using=MessageDataTypeDeserializer.class)
public enum MessageDataType {
    STRING("string"),
    SESSIONRESPONSE("SessionResponse"),
    STRUCTUREDMESSAGE("StructuredMessage"),
    PRESIGNEDURLRESPONSE("PresignedUrlResponse"),
    ATTACHMENTDELETEDRESPONSE("AttachmentDeletedResponse"),
    UPLOADFAILUREEVENT("UploadFailureEvent"),
    UPLOADSUCCESSEVENT("UploadSuccessEvent"),
    CONNECTIONCLOSEDEVENT("ConnectionClosedEvent"),
    LOGOUTEVENT("LogoutEvent"),
    SESSIONEXPIREDEVENT("SessionExpiredEvent"),
    JWTRESPONSE("JwtResponse"),
    GENERATEURLERROR("GenerateUrlError"),
    UNKNOWN("Unknown");

    private String value;

    private MessageDataType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static MessageDataType fromString(String key) {
        if (key == null) {
            return null;
        }
        for (MessageDataType value : MessageDataType.values()) {
            if (!key.equalsIgnoreCase(value.toString())) continue;
            return value;
        }
        return MessageDataType.values()[0];
    }

    @JsonValue
    public String toString() {
        return String.valueOf(this.value);
    }
}

