/*
 * Decompiled with CFR 0.152.
 */
package cloud.genesys.webmessaging.sdk.model;

import cloud.genesys.webmessaging.sdk.model.ContentAttachment;
import cloud.genesys.webmessaging.sdk.model.ContentButtonResponse;
import cloud.genesys.webmessaging.sdk.model.ContentCard;
import cloud.genesys.webmessaging.sdk.model.ContentCarousel;
import cloud.genesys.webmessaging.sdk.model.ContentGeneric;
import cloud.genesys.webmessaging.sdk.model.ContentList;
import cloud.genesys.webmessaging.sdk.model.ContentLocation;
import cloud.genesys.webmessaging.sdk.model.ContentNotificationTemplate;
import cloud.genesys.webmessaging.sdk.model.ContentPostback;
import cloud.genesys.webmessaging.sdk.model.ContentQuickReply;
import cloud.genesys.webmessaging.sdk.model.ContentQuickReplyV2;
import cloud.genesys.webmessaging.sdk.model.ContentReaction;
import cloud.genesys.webmessaging.sdk.model.ContentStory;
import cloud.genesys.webmessaging.sdk.model.ContentText;
import cloud.genesys.webmessaging.sdk.model.ContentType;
import cloud.genesys.webmessaging.sdk.model.MessagingRecipient;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Message content element. If contentType = \"Attachment\" only one item is allowed.")
public class MessageContent
implements Serializable {
    private ContentAttachment attachment = null;
    private ContentButtonResponse buttonResponse = null;
    private ContentCard card = null;
    private ContentCarousel carousel = null;
    private ContentType contentType = null;
    private ContentGeneric generic = null;
    private ContentList list = null;
    private ContentLocation location = null;
    private MessagingRecipient mention = null;
    private ContentPostback postback = null;
    private ContentQuickReply quickReply = null;
    private ContentQuickReplyV2 quickReplyV2 = null;
    private List<ContentReaction> reactions = new ArrayList<ContentReaction>();
    private ContentStory story = null;
    private ContentNotificationTemplate template = null;
    private ContentText text = null;

    public MessageContent attachment(ContentAttachment attachment) {
        this.attachment = attachment;
        return this;
    }

    @ApiModelProperty(example="null", value="Attachment content.")
    @JsonProperty(value="attachment")
    public ContentAttachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(ContentAttachment attachment) {
        this.attachment = attachment;
    }

    public MessageContent buttonResponse(ContentButtonResponse buttonResponse) {
        this.buttonResponse = buttonResponse;
        return this;
    }

    @ApiModelProperty(example="null", value="Button response content.")
    @JsonProperty(value="buttonResponse")
    public ContentButtonResponse getButtonResponse() {
        return this.buttonResponse;
    }

    public void setButtonResponse(ContentButtonResponse buttonResponse) {
        this.buttonResponse = buttonResponse;
    }

    public MessageContent card(ContentCard card) {
        this.card = card;
        return this;
    }

    @ApiModelProperty(example="null", value="Card content")
    @JsonProperty(value="card")
    public ContentCard getCard() {
        return this.card;
    }

    public void setCard(ContentCard card) {
        this.card = card;
    }

    public MessageContent carousel(ContentCarousel carousel) {
        this.carousel = carousel;
        return this;
    }

    @ApiModelProperty(example="null", value="Carousel content")
    @JsonProperty(value="carousel")
    public ContentCarousel getCarousel() {
        return this.carousel;
    }

    public void setCarousel(ContentCarousel carousel) {
        this.carousel = carousel;
    }

    public MessageContent contentType(ContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="")
    @JsonProperty(value="contentType")
    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public MessageContent generic(ContentGeneric generic) {
        this.generic = generic;
        return this;
    }

    @ApiModelProperty(example="null", value="Generic content (Deprecated).")
    @JsonProperty(value="generic")
    public ContentGeneric getGeneric() {
        return this.generic;
    }

    public void setGeneric(ContentGeneric generic) {
        this.generic = generic;
    }

    public MessageContent list(ContentList list) {
        this.list = list;
        return this;
    }

    @ApiModelProperty(example="null", value="List content (Deprecated).")
    @JsonProperty(value="list")
    public ContentList getList() {
        return this.list;
    }

    public void setList(ContentList list) {
        this.list = list;
    }

    public MessageContent location(ContentLocation location) {
        this.location = location;
        return this;
    }

    @ApiModelProperty(example="null", value="Location content.")
    @JsonProperty(value="location")
    public ContentLocation getLocation() {
        return this.location;
    }

    public void setLocation(ContentLocation location) {
        this.location = location;
    }

    public MessageContent mention(MessagingRecipient mention) {
        this.mention = mention;
        return this;
    }

    @ApiModelProperty(example="null", value="Mention content.")
    @JsonProperty(value="mention")
    public MessagingRecipient getMention() {
        return this.mention;
    }

    public void setMention(MessagingRecipient mention) {
        this.mention = mention;
    }

    public MessageContent postback(ContentPostback postback) {
        this.postback = postback;
        return this;
    }

    @ApiModelProperty(example="null", value="Structured message postback (Deprecated).")
    @JsonProperty(value="postback")
    public ContentPostback getPostback() {
        return this.postback;
    }

    public void setPostback(ContentPostback postback) {
        this.postback = postback;
    }

    public MessageContent quickReply(ContentQuickReply quickReply) {
        this.quickReply = quickReply;
        return this;
    }

    @ApiModelProperty(example="null", value="Quick reply content.")
    @JsonProperty(value="quickReply")
    public ContentQuickReply getQuickReply() {
        return this.quickReply;
    }

    public void setQuickReply(ContentQuickReply quickReply) {
        this.quickReply = quickReply;
    }

    public MessageContent quickReplyV2(ContentQuickReplyV2 quickReplyV2) {
        this.quickReplyV2 = quickReplyV2;
        return this;
    }

    @ApiModelProperty(example="null", value="Quick reply V2 content.")
    @JsonProperty(value="quickReplyV2")
    public ContentQuickReplyV2 getQuickReplyV2() {
        return this.quickReplyV2;
    }

    public void setQuickReplyV2(ContentQuickReplyV2 quickReplyV2) {
        this.quickReplyV2 = quickReplyV2;
    }

    public MessageContent reactions(List<ContentReaction> reactions) {
        this.reactions = reactions;
        return this;
    }

    @ApiModelProperty(example="null", value="A set of reactions to a message.")
    @JsonProperty(value="reactions")
    public List<ContentReaction> getReactions() {
        return this.reactions;
    }

    public void setReactions(List<ContentReaction> reactions) {
        this.reactions = reactions;
    }

    public MessageContent story(ContentStory story) {
        this.story = story;
        return this;
    }

    @ApiModelProperty(example="null", value="Ephemeral story content.")
    @JsonProperty(value="story")
    public ContentStory getStory() {
        return this.story;
    }

    public void setStory(ContentStory story) {
        this.story = story;
    }

    public MessageContent template(ContentNotificationTemplate template) {
        this.template = template;
        return this;
    }

    @ApiModelProperty(example="null", value="Template notification content.")
    @JsonProperty(value="template")
    public ContentNotificationTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(ContentNotificationTemplate template) {
        this.template = template;
    }

    public MessageContent text(ContentText text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", value="Text content.")
    @JsonProperty(value="text")
    public ContentText getText() {
        return this.text;
    }

    public void setText(ContentText text) {
        this.text = text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageContent messageContent = (MessageContent)o;
        return Objects.equals(this.attachment, messageContent.attachment) && Objects.equals(this.buttonResponse, messageContent.buttonResponse) && Objects.equals(this.card, messageContent.card) && Objects.equals(this.carousel, messageContent.carousel) && Objects.equals((Object)this.contentType, (Object)messageContent.contentType) && Objects.equals(this.generic, messageContent.generic) && Objects.equals(this.list, messageContent.list) && Objects.equals(this.location, messageContent.location) && Objects.equals(this.mention, messageContent.mention) && Objects.equals(this.postback, messageContent.postback) && Objects.equals(this.quickReply, messageContent.quickReply) && Objects.equals(this.quickReplyV2, messageContent.quickReplyV2) && Objects.equals(this.reactions, messageContent.reactions) && Objects.equals(this.story, messageContent.story) && Objects.equals(this.template, messageContent.template) && Objects.equals(this.text, messageContent.text);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attachment, this.buttonResponse, this.card, this.carousel, this.contentType, this.generic, this.list, this.location, this.mention, this.postback, this.quickReply, this.quickReplyV2, this.reactions, this.story, this.template, this.text});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageContent {\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    buttonResponse: ").append(this.toIndentedString(this.buttonResponse)).append("\n");
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("    carousel: ").append(this.toIndentedString(this.carousel)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("    generic: ").append(this.toIndentedString(this.generic)).append("\n");
        sb.append("    list: ").append(this.toIndentedString(this.list)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    mention: ").append(this.toIndentedString(this.mention)).append("\n");
        sb.append("    postback: ").append(this.toIndentedString(this.postback)).append("\n");
        sb.append("    quickReply: ").append(this.toIndentedString(this.quickReply)).append("\n");
        sb.append("    quickReplyV2: ").append(this.toIndentedString(this.quickReplyV2)).append("\n");
        sb.append("    reactions: ").append(this.toIndentedString(this.reactions)).append("\n");
        sb.append("    story: ").append(this.toIndentedString(this.story)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

