/*
 * Decompiled with CFR 0.152.
 */
package cloud.genesys.webmessaging.sdk.model;

import cloud.genesys.webmessaging.sdk.model.ButtonResponseType;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Button response content.  Button response object representing the click of a structured message button, such as a quick reply.")
public class ContentButtonResponse
implements Serializable {
    private String id = null;
    private String payload = null;
    private String text = null;
    private ButtonResponseType type = null;

    public ContentButtonResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="An ID assigned to the button response (Deprecated).")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ContentButtonResponse payload(String payload) {
        this.payload = payload;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The response payload associated with the clicked button.")
    @JsonProperty(value="payload")
    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public ContentButtonResponse text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The response text from the button click.")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public ContentButtonResponse type(ButtonResponseType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Describes the button that resulted in the Button Response.")
    @JsonProperty(value="type")
    public ButtonResponseType getType() {
        return this.type;
    }

    public void setType(ButtonResponseType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentButtonResponse contentButtonResponse = (ContentButtonResponse)o;
        return Objects.equals(this.id, contentButtonResponse.id) && Objects.equals(this.payload, contentButtonResponse.payload) && Objects.equals(this.text, contentButtonResponse.text) && Objects.equals((Object)this.type, (Object)contentButtonResponse.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.payload, this.text, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContentButtonResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

