/*
 * Decompiled with CFR 0.152.
 */
package cloud.genesys.webmessaging.sdk.model;

import cloud.genesys.webmessaging.sdk.model.MediaType;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Attachment content.  Media template header image.  Attachment object.")
public class ContentAttachment
implements Serializable {
    private Double contentSizeBytes = null;
    private String filename = null;
    private String id = null;
    private MediaType mediaType = null;
    private String mime = null;
    private String sha256 = null;
    private String text = null;
    private String url = null;

    public ContentAttachment contentSizeBytes(Double contentSizeBytes) {
        this.contentSizeBytes = contentSizeBytes;
        return this;
    }

    @ApiModelProperty(example="null", value="Size in bytes of the attachment content.")
    @JsonProperty(value="contentSizeBytes")
    public Double getContentSizeBytes() {
        return this.contentSizeBytes;
    }

    public void setContentSizeBytes(Double contentSizeBytes) {
        this.contentSizeBytes = contentSizeBytes;
    }

    public ContentAttachment filename(String filename) {
        this.filename = filename;
        return this;
    }

    @ApiModelProperty(example="null", value="Suggested file name for attachment.")
    @JsonProperty(value="filename")
    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public ContentAttachment id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Provider specific ID for attachment. For example, a LINE sticker ID.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ContentAttachment mediaType(MediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of attachment this instance represents.")
    @JsonProperty(value="mediaType")
    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public ContentAttachment mime(String mime) {
        this.mime = mime;
        return this;
    }

    @ApiModelProperty(example="null", value="Attachment mime type (https://www.iana.org/assignments/media-types/media-types.xhtml).")
    @JsonProperty(value="mime")
    public String getMime() {
        return this.mime;
    }

    public void setMime(String mime) {
        this.mime = mime;
    }

    public ContentAttachment sha256(String sha256) {
        this.sha256 = sha256;
        return this;
    }

    @ApiModelProperty(example="null", value="Secure hash of the attachment content.")
    @JsonProperty(value="sha256")
    public String getSha256() {
        return this.sha256;
    }

    public void setSha256(String sha256) {
        this.sha256 = sha256;
    }

    public ContentAttachment text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", value="Text associated with attachment such as an image caption.")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public ContentAttachment url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="null", value="URL of the attachment.")
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentAttachment contentAttachment = (ContentAttachment)o;
        return Objects.equals(this.contentSizeBytes, contentAttachment.contentSizeBytes) && Objects.equals(this.filename, contentAttachment.filename) && Objects.equals(this.id, contentAttachment.id) && Objects.equals((Object)this.mediaType, (Object)contentAttachment.mediaType) && Objects.equals(this.mime, contentAttachment.mime) && Objects.equals(this.sha256, contentAttachment.sha256) && Objects.equals(this.text, contentAttachment.text) && Objects.equals(this.url, contentAttachment.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contentSizeBytes, this.filename, this.id, this.mediaType, this.mime, this.sha256, this.text, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContentAttachment {\n");
        sb.append("    contentSizeBytes: ").append(this.toIndentedString(this.contentSizeBytes)).append("\n");
        sb.append("    filename: ").append(this.toIndentedString(this.filename)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    mime: ").append(this.toIndentedString(this.mime)).append("\n");
        sb.append("    sha256: ").append(this.toIndentedString(this.sha256)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

