/*
 * Decompiled with CFR 0.152.
 */
package cloud.genesys.webmessaging.sdk.connector.apache;

import cloud.genesys.webmessaging.sdk.DetailLevel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.RequestLine;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicRequestLine;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JInterceptor
implements HttpRequestInterceptor,
HttpResponseInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SLF4JInterceptor.class);
    private static final String SLF4J_REQUEST_DATA = "slf4j-request-data";
    private volatile DetailLevel detailLevel;

    public SLF4JInterceptor() {
        this(DetailLevel.MINIMAL);
    }

    public SLF4JInterceptor(DetailLevel detailLevel) {
        this.detailLevel = detailLevel;
    }

    public DetailLevel getDetailLevel() {
        return this.detailLevel;
    }

    public void setDetailLevel(DetailLevel detailLevel) {
        this.detailLevel = detailLevel;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (LOGGER.isDebugEnabled()) {
            RequestData requestData = new RequestData(request.getRequestLine(), System.currentTimeMillis());
            context.setAttribute(SLF4J_REQUEST_DATA, (Object)requestData);
            this.logRequest(request);
        }
    }

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (LOGGER.isDebugEnabled()) {
            long tookMs;
            RequestLine requestLine;
            Object reqDataAttr = context.getAttribute(SLF4J_REQUEST_DATA);
            if (reqDataAttr == null || !(reqDataAttr instanceof RequestData)) {
                LOGGER.error("Could not determine the request associated with this response");
                requestLine = new BasicRequestLine("<UNKNOWN METHOD>", "<UNKNOWN URL>", null);
                tookMs = -1L;
            } else {
                RequestData requestData = (RequestData)reqDataAttr;
                requestLine = requestData.requestLine;
                tookMs = System.currentTimeMillis() - requestData.startTime;
            }
            this.logResponse(response, requestLine, tookMs);
        }
    }

    private void logRequest(HttpRequest request) throws IOException {
        if (this.detailLevel.compareTo(DetailLevel.MINIMAL) >= 0) {
            StringBuilder messageBuilder = new StringBuilder();
            String uriString = String.format(">>>> %s %s >>>>", request.getRequestLine().getMethod(), request.getRequestLine().getUri());
            messageBuilder.append(uriString).append(System.lineSeparator());
            if (this.detailLevel.compareTo(DetailLevel.HEADERS) >= 0) {
                messageBuilder.append("---- HEADERS ----").append(System.lineSeparator());
                messageBuilder.append(SLF4JInterceptor.formatHeaders(request.getAllHeaders()));
                if (this.detailLevel.compareTo(DetailLevel.FULL) >= 0) {
                    if (request instanceof HttpEntityEnclosingRequest && ((HttpEntityEnclosingRequest)request).getEntity() != null) {
                        byte[] data = SLF4JInterceptor.extractRequestBody((HttpEntityEnclosingRequest)request);
                        messageBuilder.append(String.format("---- BODY (%d bytes) ----", data.length)).append(System.lineSeparator());
                        messageBuilder.append(new String(data)).append(System.lineSeparator());
                    } else {
                        messageBuilder.append("---- NO BODY ----").append(System.lineSeparator());
                    }
                }
                messageBuilder.append(">>>> END >>>>").append(System.lineSeparator());
            }
            LOGGER.debug(messageBuilder.toString());
        }
    }

    private void logResponse(HttpResponse response, RequestLine requestLine, long tookMs) throws IOException {
        if (this.detailLevel.compareTo(DetailLevel.MINIMAL) >= 0) {
            StringBuilder messageBuilder = new StringBuilder();
            String uriString = String.format("<<<< %s %s <<<<", requestLine.getMethod(), requestLine.getUri());
            messageBuilder.append(uriString).append(System.lineSeparator());
            messageBuilder.append(String.format("     %d %s  (%d ms)", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), tookMs)).append(System.lineSeparator());
            if (this.detailLevel.compareTo(DetailLevel.HEADERS) >= 0) {
                messageBuilder.append("---- HEADERS ----").append(System.lineSeparator());
                messageBuilder.append(SLF4JInterceptor.formatHeaders(response.getAllHeaders()));
                if (this.detailLevel.compareTo(DetailLevel.FULL) >= 0) {
                    if (response.getEntity() != null) {
                        byte[] responseBody = SLF4JInterceptor.extractResponseBody(response);
                        messageBuilder.append(String.format("---- BODY (%d bytes) ----", responseBody.length)).append(System.lineSeparator());
                        messageBuilder.append(new String(responseBody)).append(System.lineSeparator());
                    } else {
                        messageBuilder.append("---- NO BODY ----").append(System.lineSeparator());
                    }
                }
                messageBuilder.append("<<<< END <<<<").append(System.lineSeparator());
            }
            LOGGER.debug(messageBuilder.toString());
        }
    }

    private static final byte[] extractRequestBody(HttpEntityEnclosingRequest request) throws IOException {
        byte[] data = SLF4JInterceptor.toByteArray(request.getEntity().getContent());
        if (!request.getEntity().isRepeatable()) {
            request.setEntity((HttpEntity)new ByteArrayEntity(data, ContentType.get((HttpEntity)request.getEntity())));
        }
        return data;
    }

    private static final byte[] extractResponseBody(HttpResponse response) throws IOException {
        byte[] data = SLF4JInterceptor.toByteArray(response.getEntity().getContent());
        if (!response.getEntity().isRepeatable()) {
            response.setEntity((HttpEntity)new ByteArrayEntity(data, ContentType.get((HttpEntity)response.getEntity())));
        }
        return data;
    }

    private static final byte[] toByteArray(InputStream response) throws IOException {
        int BUFFER_SIZE = 2048;
        byte[] buffer = new byte[2048];
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        try (InputStream stream = response;){
            int read;
            while ((read = stream.read(buffer)) != -1) {
                byteArrayStream.write(buffer, 0, read);
            }
            byteArrayStream.flush();
        }
        return byteArrayStream.toByteArray();
    }

    private static String formatHeaders(Header[] headers) {
        List<Header> sortedHeaders = Arrays.asList(headers);
        Collections.sort(sortedHeaders, new HeaderComparator());
        StringBuilder sb = new StringBuilder();
        for (Header header : sortedHeaders) {
            String headerString = String.format("%s: %s", header.getName(), header.getValue());
            sb.append(headerString).append(System.lineSeparator());
        }
        return sb.toString();
    }

    private static class RequestData {
        public final RequestLine requestLine;
        public final long startTime;

        private RequestData(RequestLine requestLine, long startTime) {
            this.requestLine = requestLine;
            this.startTime = startTime;
        }
    }

    private static class HeaderComparator
    implements Comparator<Header> {
        private HeaderComparator() {
        }

        @Override
        public int compare(Header a, Header b) {
            return a.getName().compareTo(b.getName());
        }
    }
}

