/*
 * Decompiled with CFR 0.152.
 */
package cloud.genesys.webmessaging.sdk;

import cloud.genesys.webmessaging.sdk.ApiClient;
import cloud.genesys.webmessaging.sdk.Configuration;
import cloud.genesys.webmessaging.sdk.GenesysCloudRegionWebSocketHosts;
import cloud.genesys.webmessaging.sdk.WebMessagingException;
import cloud.genesys.webmessaging.sdk.api.WebMessagingApi;
import cloud.genesys.webmessaging.sdk.api.request.GetWebmessagingMessagesRequest;
import cloud.genesys.webmessaging.sdk.model.BaseChannelMetadata;
import cloud.genesys.webmessaging.sdk.model.BaseMessage;
import cloud.genesys.webmessaging.sdk.model.BaseMessagingChannel;
import cloud.genesys.webmessaging.sdk.model.ConfigureAuthenticatedSessionRequest;
import cloud.genesys.webmessaging.sdk.model.ConfigureSessionRequest;
import cloud.genesys.webmessaging.sdk.model.ConnectionClosedEvent;
import cloud.genesys.webmessaging.sdk.model.ContentAttachment;
import cloud.genesys.webmessaging.sdk.model.ContentType;
import cloud.genesys.webmessaging.sdk.model.DeleteAttachmentRequest;
import cloud.genesys.webmessaging.sdk.model.EventPresence;
import cloud.genesys.webmessaging.sdk.model.EventPresenceType;
import cloud.genesys.webmessaging.sdk.model.EventType;
import cloud.genesys.webmessaging.sdk.model.EventTyping;
import cloud.genesys.webmessaging.sdk.model.EventTypingType;
import cloud.genesys.webmessaging.sdk.model.GenerateDownloadUrlRequest;
import cloud.genesys.webmessaging.sdk.model.GenerateUploadUrlRequest;
import cloud.genesys.webmessaging.sdk.model.GetJwtRequest;
import cloud.genesys.webmessaging.sdk.model.IncomingNormalizedMessage;
import cloud.genesys.webmessaging.sdk.model.JwtResponse;
import cloud.genesys.webmessaging.sdk.model.MessageContent;
import cloud.genesys.webmessaging.sdk.model.MessageEvent;
import cloud.genesys.webmessaging.sdk.model.NormalizedType;
import cloud.genesys.webmessaging.sdk.model.OAuthParams;
import cloud.genesys.webmessaging.sdk.model.PresignedUrlResponse;
import cloud.genesys.webmessaging.sdk.model.RequestTypeConfigureAuthenticatedSession;
import cloud.genesys.webmessaging.sdk.model.RequestTypeConfigureSession;
import cloud.genesys.webmessaging.sdk.model.RequestTypeDeleteAttachment;
import cloud.genesys.webmessaging.sdk.model.RequestTypeEchoMessage;
import cloud.genesys.webmessaging.sdk.model.RequestTypeGenerateDownloadUrl;
import cloud.genesys.webmessaging.sdk.model.RequestTypeGenerateUploadUrl;
import cloud.genesys.webmessaging.sdk.model.RequestTypeGetJwt;
import cloud.genesys.webmessaging.sdk.model.RequestTypeIncomingMessage;
import cloud.genesys.webmessaging.sdk.model.SendEchoRequest;
import cloud.genesys.webmessaging.sdk.model.SendMessageRequest;
import cloud.genesys.webmessaging.sdk.model.SessionClearedEvent;
import cloud.genesys.webmessaging.sdk.model.SessionExpiredEvent;
import cloud.genesys.webmessaging.sdk.model.SessionResponse;
import cloud.genesys.webmessaging.sdk.model.StructuredMessage;
import cloud.genesys.webmessaging.sdk.model.UploadFailureEvent;
import cloud.genesys.webmessaging.sdk.model.UploadSuccessEvent;
import cloud.genesys.webmessaging.sdk.model.WebMessagingMessage;
import cloud.genesys.webmessaging.sdk.model.WebMessagingMessageEntityList;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class WebMessagingClient {
    private final String webSocketAddress;
    private WebSocket webSocket;
    private String token;
    private String jwt;
    private String deploymentId;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ArrayList<SessionListener> sessionListeners = new ArrayList();
    private ApiClient apiClient;

    public static boolean hasPresenceEvents(StructuredMessage message) {
        return WebMessagingClient.hasEvents(message, EventType.PRESENCE);
    }

    public static boolean hasTypingEvents(StructuredMessage message) {
        return WebMessagingClient.hasEvents(message, EventType.TYPING);
    }

    public static boolean hasEvents(StructuredMessage message, EventType type) {
        return message.getEvents().stream().anyMatch(messageEvent -> messageEvent.getEventType() == type);
    }

    public WebMessagingClient(String address) {
        this.webSocketAddress = address;
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        this.objectMapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.objectMapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        this.objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    public WebMessagingClient(GenesysCloudRegionWebSocketHosts region) {
        this(region.getWebSocketHost());
    }

    public void joinConversation(String deploymentId, String initialMessage, String origin) {
        this.joinConversation(deploymentId, UUID.randomUUID().toString(), initialMessage, origin);
    }

    public void joinConversation(final String deploymentId, final String token, String initialMessage, String origin) {
        SessionListener listener = new SessionListener(){

            @Override
            public void sessionResponse(SessionResponse response, String rawResponse) {
            }

            @Override
            public void structuredMessage(StructuredMessage message, String rawResponse) {
            }

            @Override
            public void unexpectedMessage(BaseMessage baseMessage, String rawResponse) {
            }

            @Override
            public void presignedUrlResponse(PresignedUrlResponse presignedUrl, String rawResponse) {
            }

            @Override
            public void uploadSuccessEvent(UploadSuccessEvent uploadSuccessEvent, String rawMessage) {
            }

            @Override
            public void uploadFailureEvent(UploadFailureEvent uploadFailureEvent, String rawMessage) {
            }

            @Override
            public void connectionClosedEvent(ConnectionClosedEvent cnxClosedResponse, String rawMessage) {
            }

            @Override
            public void sessionExpiredEvent(SessionExpiredEvent sessionExpiredResponse, String rawMessage) {
            }

            @Override
            public void sessionClearedEvent(SessionClearedEvent sessionClearedResponse, String rawMessage) {
            }

            @Override
            public void jwtResponse(JwtResponse jwtResponse, String rawMessage) {
                WebMessagingClient.this.jwt = jwtResponse.getJwt();
            }

            @Override
            public void webSocketConnected() {
                WebMessagingClient.this.configureSession(deploymentId, token);
            }

            @Override
            public void webSocketDisconnected(int statusCode, String reason) {
            }

            @Override
            public void webSocketError(String reason) {
            }
        };
        this.connect(deploymentId, origin);
        this.addSessionListener(listener);
    }

    public void connect(String deploymentId, String origin) {
        this.connect(deploymentId, origin, Optional.empty(), Optional.empty());
    }

    public void connect(String deploymentId, String origin, Optional<Integer> connectionTimeout, Optional<String> userAgent) {
        WebSocket.Listener listener = new WebSocket.Listener(){

            @Override
            public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
                BaseMessage baseResponse = WebMessagingClient.this.deserialize(data.toString(), BaseMessage.class);
                if (baseResponse != null) {
                    WebMessagingClient.this.onSessionEvent(data.toString(), baseResponse);
                }
                return WebSocket.Listener.super.onText(webSocket, data, last);
            }

            @Override
            public void onOpen(WebSocket webSocket) {
                WebMessagingClient.this.webSocket = webSocket;
                WebMessagingClient.this.onWebSocketConnected();
                WebSocket.Listener.super.onOpen(webSocket);
            }

            @Override
            public void onError(WebSocket webSocket, Throwable error) {
                WebMessagingClient.this.onWebSocketError(error.getMessage());
                WebSocket.Listener.super.onError(webSocket, error);
            }

            @Override
            public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
                WebMessagingClient.this.onWebSocketDisconnected(statusCode, reason);
                return WebSocket.Listener.super.onClose(webSocket, statusCode, reason);
            }
        };
        WebSocket.Builder builder = HttpClient.newHttpClient().newWebSocketBuilder().header("Origin", origin).header("deploymentId", deploymentId).header("user-agent", userAgent.orElse("WebMessagingSDK-1.0.0"));
        if (connectionTimeout.isPresent()) {
            builder.connectTimeout(Duration.ofSeconds(connectionTimeout.get().intValue()));
        }
        CompletableFuture<WebSocket> completableFuture = builder.buildAsync(URI.create(this.webSocketAddress + "?deploymentId=" + deploymentId), listener);
        completableFuture.join();
    }

    public boolean isInputClosed() {
        return this.webSocket.isInputClosed();
    }

    public boolean isOutputClosed() {
        return this.webSocket.isOutputClosed();
    }

    public void configureSession(String deploymentId, String origin) {
        this.configureSession(deploymentId, UUID.randomUUID().toString(), origin, Optional.empty());
    }

    public void configureSession(String deploymentId, String token, String origin, Optional<Boolean> startNew) {
        try {
            this.token = token;
            this.deploymentId = deploymentId;
            if (this.apiClient == null) {
                this.initializeApiClient(origin);
            }
            ConfigureSessionRequest configureSessionRequest = new ConfigureSessionRequest();
            configureSessionRequest.setAction(RequestTypeConfigureSession.CONFIGURESESSION);
            configureSessionRequest.setDeploymentId(deploymentId);
            configureSessionRequest.setToken(token);
            startNew.ifPresent(boolValue -> configureSessionRequest.setStartNew((Boolean)boolValue));
            String payload = this.objectMapper.writeValueAsString((Object)configureSessionRequest);
            this.webSocket.sendText(payload, true);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public void configureAuthenticatedSession(String deploymentId, String origin, OAuthParams data) {
        this.configureAuthenticatedSession(deploymentId, UUID.randomUUID().toString(), origin, data);
    }

    public void configureAuthenticatedSession(String deploymentId, String token, String origin, OAuthParams data) {
        try {
            this.token = token;
            this.deploymentId = deploymentId;
            if (this.apiClient == null) {
                this.initializeApiClient(origin);
            }
            ConfigureAuthenticatedSessionRequest configureAuthenticatedSessionRequest = new ConfigureAuthenticatedSessionRequest();
            configureAuthenticatedSessionRequest.setAction(RequestTypeConfigureAuthenticatedSession.CONFIGUREAUTHENTICATEDSESSION);
            configureAuthenticatedSessionRequest.setDeploymentId(deploymentId);
            configureAuthenticatedSessionRequest.setToken(token);
            configureAuthenticatedSessionRequest.setData(data);
            String payload = this.objectMapper.writeValueAsString((Object)configureAuthenticatedSessionRequest);
            this.webSocket.sendText(payload, true);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public void disconnect() {
        this.webSocket.sendClose(1000, "Guest client disconnect");
    }

    public void ping() {
        try {
            SendEchoRequest sendEchoRequest = new SendEchoRequest();
            sendEchoRequest.token(this.token);
            sendEchoRequest.setAction(RequestTypeEchoMessage.ECHO);
            IncomingNormalizedMessage incomingNormalizedMessage = new IncomingNormalizedMessage();
            incomingNormalizedMessage.setType(NormalizedType.TEXT);
            incomingNormalizedMessage.setText("ping");
            sendEchoRequest.setMessage(incomingNormalizedMessage);
            String payload = this.objectMapper.writeValueAsString((Object)sendEchoRequest);
            this.webSocket.sendText(payload, true);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public void sendMessage(String message, String ... attachmentIds) {
        this.sendMessage(message, (Map<String, String>)null, attachmentIds);
    }

    public void sendMessage(String message, Map<String, String> customAttributes, String ... attachmentIds) {
        try {
            SendMessageRequest sendMessageRequest = new SendMessageRequest();
            sendMessageRequest.token(this.token);
            sendMessageRequest.action(RequestTypeIncomingMessage.ONMESSAGE);
            IncomingNormalizedMessage normalizedMessage = new IncomingNormalizedMessage();
            sendMessageRequest.message(normalizedMessage.type(NormalizedType.TEXT).text(message));
            if (customAttributes != null) {
                BaseMessagingChannel baseMessagingChannel = new BaseMessagingChannel();
                BaseChannelMetadata baseChannelMetadata = new BaseChannelMetadata();
                baseChannelMetadata.customAttributes(customAttributes);
                baseMessagingChannel.metadata(baseChannelMetadata);
                sendMessageRequest.channel(baseMessagingChannel);
            }
            for (String attachmentId : attachmentIds) {
                normalizedMessage.getContent().add(new MessageContent().contentType(ContentType.ATTACHMENT).attachment(new ContentAttachment().id(attachmentId)));
            }
            String payload = this.objectMapper.writeValueAsString((Object)sendMessageRequest);
            this.webSocket.sendText(payload, true);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public void sendPresenceEvent(EventPresenceType type) {
        try {
            SendMessageRequest sendMessageRequest = new SendMessageRequest();
            sendMessageRequest.token(this.token);
            sendMessageRequest.action(RequestTypeIncomingMessage.ONMESSAGE);
            sendMessageRequest.message(new IncomingNormalizedMessage().type(NormalizedType.EVENT).events(Collections.singletonList(new MessageEvent().eventType(EventType.PRESENCE).presence(new EventPresence().type(type)))));
            String payload = this.objectMapper.writeValueAsString((Object)sendMessageRequest);
            this.webSocket.sendText(payload, true);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public void sendPresenceEvent() {
        this.sendPresenceEventJoin();
    }

    public void sendPresenceEventJoin() {
        this.sendPresenceEvent(EventPresenceType.JOIN);
    }

    public void sendPresenceEventEndUserClear() {
        this.sendPresenceEvent(EventPresenceType.CLEAR);
    }

    public void sendTypingEvent() {
        try {
            SendMessageRequest sendMessageRequest = new SendMessageRequest();
            sendMessageRequest.token(this.token);
            sendMessageRequest.action(RequestTypeIncomingMessage.ONMESSAGE);
            sendMessageRequest.message(new IncomingNormalizedMessage().type(NormalizedType.EVENT).events(Collections.singletonList(new MessageEvent().eventType(EventType.TYPING).typing(new EventTyping().type(EventTypingType.ON)))));
            String payload = this.objectMapper.writeValueAsString((Object)sendMessageRequest);
            this.webSocket.sendText(payload, true);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public void attachment(String fileName, int fileSize, String fileType) {
        try {
            GenerateUploadUrlRequest generateUploadUrlRequest = new GenerateUploadUrlRequest().token(this.token).action(RequestTypeGenerateUploadUrl.ONATTACHMENT).fileName(fileName).fileSize(fileSize).fileType(fileType);
            String payload = this.objectMapper.writeValueAsString((Object)generateUploadUrlRequest);
            this.webSocket.sendText(payload, true);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public void getAttachment(String attachmentId) {
        try {
            GenerateDownloadUrlRequest generateDownloadUrlRequest = new GenerateDownloadUrlRequest().token(this.token).action(RequestTypeGenerateDownloadUrl.GETATTACHMENT).attachmentId(attachmentId);
            String payload = this.objectMapper.writeValueAsString((Object)generateDownloadUrlRequest);
            this.webSocket.sendText(payload, true);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public void deleteAttachment(String attachmentId) {
        try {
            DeleteAttachmentRequest deleteAttachmentRequest = new DeleteAttachmentRequest().token(this.token).action(RequestTypeDeleteAttachment.DELETEATTACHMENT).attachmentId(attachmentId);
            String payload = this.objectMapper.writeValueAsString((Object)deleteAttachmentRequest);
            this.webSocket.sendText(payload, true);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public void getJwt() {
        try {
            GetJwtRequest getJwtRequest = new GetJwtRequest().token(this.token).action(RequestTypeGetJwt.GETJWT);
            String payload = this.objectMapper.writeValueAsString((Object)getJwtRequest);
            this.webSocket.sendText(payload, true);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    private <T> T deserialize(String json, Class<T> type) {
        try {
            return (T)this.objectMapper.readValue(json, type);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    private void onSessionEvent(String rawMessage, BaseMessage baseMessage) {
        Class<?> messageClass;
        String className = baseMessage.getClassProperty().toString();
        try {
            messageClass = Class.forName(this.getClass().getPackageName() + ".model." + className);
        }
        catch (ClassNotFoundException e) {
            for (SessionListener sessionListener : this.sessionListeners) {
                sessionListener.unexpectedMessage(baseMessage, rawMessage);
            }
            return;
        }
        Object response = this.objectMapper.convertValue(baseMessage.getBody(), messageClass);
        switch (className) {
            case "SessionResponse": {
                for (SessionListener sessionListener : this.sessionListeners) {
                    sessionListener.sessionResponse((SessionResponse)response, rawMessage);
                }
                break;
            }
            case "StructuredMessage": {
                for (SessionListener sessionListener : this.sessionListeners) {
                    sessionListener.structuredMessage((StructuredMessage)response, rawMessage);
                }
                break;
            }
            case "PresignedUrlResponse": {
                for (SessionListener sessionListener : this.sessionListeners) {
                    sessionListener.presignedUrlResponse((PresignedUrlResponse)response, rawMessage);
                }
                break;
            }
            case "UploadSuccessEvent": {
                for (SessionListener sessionListener : this.sessionListeners) {
                    sessionListener.uploadSuccessEvent((UploadSuccessEvent)response, rawMessage);
                }
                break;
            }
            case "UploadFailureEvent": {
                for (SessionListener sessionListener : this.sessionListeners) {
                    sessionListener.uploadFailureEvent((UploadFailureEvent)response, rawMessage);
                }
                break;
            }
            case "ConnectionClosedEvent": {
                for (SessionListener sessionListener : this.sessionListeners) {
                    sessionListener.connectionClosedEvent((ConnectionClosedEvent)response, rawMessage);
                }
                break;
            }
            case "SessionExpiredEvent": {
                for (SessionListener sessionListener : this.sessionListeners) {
                    sessionListener.sessionExpiredEvent((SessionExpiredEvent)response, rawMessage);
                }
                break;
            }
            case "SessionClearedEvent": {
                for (SessionListener sessionListener : this.sessionListeners) {
                    sessionListener.sessionClearedEvent((SessionClearedEvent)response, rawMessage);
                }
                break;
            }
            case "JwtResponse": {
                for (SessionListener sessionListener : this.sessionListeners) {
                    sessionListener.jwtResponse((JwtResponse)response, rawMessage);
                }
                break;
            }
            default: {
                for (SessionListener sessionListener : this.sessionListeners) {
                    sessionListener.unexpectedMessage(baseMessage, rawMessage);
                }
            }
        }
    }

    private void onWebSocketConnected() {
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.webSocketConnected();
        }
    }

    private void onWebSocketDisconnected(int statusCode, String reason) {
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.webSocketDisconnected(statusCode, reason);
        }
    }

    private void onWebSocketError(String reason) {
        for (SessionListener sessionListener : this.sessionListeners) {
            sessionListener.webSocketError(reason);
        }
    }

    public void addSessionListener(SessionListener sessionListener) {
        this.sessionListeners.add(sessionListener);
    }

    public void removeSessionListener(SessionListener sessionListener) {
        this.sessionListeners.removeIf(l -> l.equals(sessionListener));
    }

    public WebMessagingMessageEntityList getHistory() throws IOException, WebMessagingException {
        if (this.apiClient == null) {
            throw new WebMessagingException(new Exception("A conversation must be joined before the history can be retrieved"));
        }
        this.apiClient.setAccessToken(this.jwt);
        GetWebmessagingMessagesRequest request = GetWebmessagingMessagesRequest.builder().withPageSize(100).build();
        WebMessagingApi webMessagingApi = new WebMessagingApi();
        WebMessagingMessageEntityList messageEntityList = webMessagingApi.getWebmessagingMessages(request);
        List<WebMessagingMessage> list = messageEntityList.getEntities();
        int pageNumber = 2;
        do {
            request.setPageNumber(pageNumber++);
            messageEntityList = webMessagingApi.getWebmessagingMessages(request);
            list.addAll(messageEntityList.getEntities());
        } while (messageEntityList.getEntities().size() > 0);
        return messageEntityList.entities(list);
    }

    private void initializeApiClient(String origin) {
        String basePath = GenesysCloudRegionWebSocketHosts.asApiHost(this.webSocketAddress);
        this.apiClient = ApiClient.Builder.standard().withBasePath(basePath).withAccessToken(this.token).withDefaultHeader("Origin", origin).build();
        Configuration.setDefaultApiClient(this.apiClient);
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
        Configuration.setDefaultApiClient(this.apiClient);
    }

    public static interface SessionListener
    extends EventListener {
        public void sessionResponse(SessionResponse var1, String var2);

        public void structuredMessage(StructuredMessage var1, String var2);

        public void presignedUrlResponse(PresignedUrlResponse var1, String var2);

        public void uploadSuccessEvent(UploadSuccessEvent var1, String var2);

        public void uploadFailureEvent(UploadFailureEvent var1, String var2);

        public void connectionClosedEvent(ConnectionClosedEvent var1, String var2);

        public void sessionExpiredEvent(SessionExpiredEvent var1, String var2);

        public void sessionClearedEvent(SessionClearedEvent var1, String var2);

        public void jwtResponse(JwtResponse var1, String var2);

        public void unexpectedMessage(BaseMessage var1, String var2);

        public void webSocketConnected();

        public void webSocketDisconnected(int var1, String var2);

        public void webSocketError(String var1);
    }
}

