/*
 * Decompiled with CFR 0.152.
 */
package cloud.genesys.webmessaging.sdk.model;

import cloud.genesys.webmessaging.sdk.model.WebMessagingChannel;
import cloud.genesys.webmessaging.sdk.model.WebMessagingContent;
import cloud.genesys.webmessaging.sdk.model.WebMessagingEvent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="A web messaging message")
public class WebMessagingMessage
implements Serializable {
    private String id = null;
    private WebMessagingChannel channel = null;
    private TypeEnum type = null;
    private String text = null;
    private List<WebMessagingContent> content = new ArrayList<WebMessagingContent>();
    private List<WebMessagingEvent> events = new ArrayList<WebMessagingEvent>();
    private DirectionEnum direction = null;
    private OriginatingEntityEnum originatingEntity = null;
    private Map<String, String> metadata = null;

    public WebMessagingMessage id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique ID of the message. This ID is generated by Messaging Platform. Message receipts will have the same ID as the message they reference.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WebMessagingMessage channel(WebMessagingChannel channel) {
        this.channel = channel;
        return this;
    }

    @ApiModelProperty(example="null", value="Channel-specific information that describes the message and the message channel/provider.")
    @JsonProperty(value="channel")
    public WebMessagingChannel getChannel() {
        return this.channel;
    }

    public void setChannel(WebMessagingChannel channel) {
        this.channel = channel;
    }

    public WebMessagingMessage type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="Message type.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public WebMessagingMessage text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", value="Message text.")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public WebMessagingMessage content(List<WebMessagingContent> content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(example="null", value="List of content elements.")
    @JsonProperty(value="content")
    public List<WebMessagingContent> getContent() {
        return this.content;
    }

    public void setContent(List<WebMessagingContent> content) {
        this.content = content;
    }

    public WebMessagingMessage events(List<WebMessagingEvent> events) {
        this.events = events;
        return this;
    }

    @ApiModelProperty(example="null", value="List of event elements.")
    @JsonProperty(value="events")
    public List<WebMessagingEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<WebMessagingEvent> events) {
        this.events = events;
    }

    public WebMessagingMessage direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="The direction of the message.  Direction is always from the perspective of the Genesys Cloud platform.  An Inbound message is one sent from a guest to the Genesys Cloud Platform.  An Outbound message is one sent from the Genesys Cloud Platform to a guest.")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public WebMessagingMessage originatingEntity(OriginatingEntityEnum originatingEntity) {
        this.originatingEntity = originatingEntity;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies if this message was sent by a human agent or bot. The platform may use this to apply appropriate provider policies.")
    @JsonProperty(value="originatingEntity")
    public OriginatingEntityEnum getOriginatingEntity() {
        return this.originatingEntity;
    }

    public void setOriginatingEntity(OriginatingEntityEnum originatingEntity) {
        this.originatingEntity = originatingEntity;
    }

    public WebMessagingMessage metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional metadata about this message.")
    @JsonProperty(value="metadata")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebMessagingMessage webMessagingMessage = (WebMessagingMessage)o;
        return Objects.equals(this.id, webMessagingMessage.id) && Objects.equals(this.channel, webMessagingMessage.channel) && Objects.equals((Object)this.type, (Object)webMessagingMessage.type) && Objects.equals(this.text, webMessagingMessage.text) && Objects.equals(this.content, webMessagingMessage.content) && Objects.equals(this.events, webMessagingMessage.events) && Objects.equals((Object)this.direction, (Object)webMessagingMessage.direction) && Objects.equals((Object)this.originatingEntity, (Object)webMessagingMessage.originatingEntity) && Objects.equals(this.metadata, webMessagingMessage.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.channel, this.type, this.text, this.content, this.events, this.direction, this.originatingEntity, this.metadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebMessagingMessage {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString(this.channel)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    originatingEntity: ").append(this.toIndentedString((Object)this.originatingEntity)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TEXT("Text"),
        STRUCTURED("Structured"),
        RECEIPT("Receipt"),
        EVENT("Event");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DirectionEnumDeserializer.class)
    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("Inbound"),
        OUTBOUND("Outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=OriginatingEntityEnumDeserializer.class)
    public static enum OriginatingEntityEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        HUMAN("Human"),
        BOT("Bot");

        private String value;

        private OriginatingEntityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OriginatingEntityEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OriginatingEntityEnum value : OriginatingEntityEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OriginatingEntityEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OriginatingEntityEnumDeserializer
    extends StdDeserializer<OriginatingEntityEnum> {
        public OriginatingEntityEnumDeserializer() {
            super(OriginatingEntityEnumDeserializer.class);
        }

        public OriginatingEntityEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OriginatingEntityEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class DirectionEnumDeserializer
    extends StdDeserializer<DirectionEnum> {
        public DirectionEnumDeserializer() {
            super(DirectionEnumDeserializer.class);
        }

        public DirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

