/*
 * Decompiled with CFR 0.152.
 */
package cloud.genesys.webmessaging.sdk.connector.okhttp;

import cloud.genesys.webmessaging.sdk.connector.ApiClientConnector;
import cloud.genesys.webmessaging.sdk.connector.ApiClientConnectorRequest;
import cloud.genesys.webmessaging.sdk.connector.ApiClientConnectorResponse;
import cloud.genesys.webmessaging.sdk.connector.okhttp.OkHttpResponse;
import java.io.IOException;
import java.util.Map;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class OkHttpClientConnector
implements ApiClientConnector {
    private final OkHttpClient client;

    public OkHttpClientConnector(OkHttpClient client) {
        this.client = client;
    }

    @Override
    public ApiClientConnectorResponse invoke(ApiClientConnectorRequest request) throws IOException {
        Call call = this.client.newCall(this.buildRequest(request));
        return new OkHttpResponse(call.execute());
    }

    private Request buildRequest(ApiClientConnectorRequest request) throws IOException {
        String method;
        Request.Builder builder = new Request.Builder().url(request.getUrl());
        Map<String, String> headers = request.getHeaders();
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                builder = builder.addHeader(header.getKey(), header.getValue());
            }
        }
        if ("GET".equals(method = request.getMethod())) {
            builder = builder.get();
        } else if ("HEAD".equals(method)) {
            builder = builder.head();
        } else if ("POST".equals(method)) {
            builder = builder.post(this.createBody(request));
        } else if ("PUT".equals(method)) {
            builder = builder.put(this.createBody(request));
        } else if ("DELETE".equals(method)) {
            builder = builder.delete();
        } else if ("PATCH".equals(method)) {
            builder = builder.patch(this.createBody(request));
        } else {
            throw new IllegalStateException("Unknown method type " + method);
        }
        return builder.build();
    }

    private RequestBody createBody(ApiClientConnectorRequest request) throws IOException {
        String contentType = "application/json";
        Map<String, String> headers = request.getHeaders();
        if (headers != null && !headers.isEmpty()) {
            for (String name : headers.keySet()) {
                if (!name.equalsIgnoreCase("content-type")) continue;
                contentType = headers.get(name);
                break;
            }
        }
        if (request.hasBody()) {
            return RequestBody.create((MediaType)MediaType.parse((String)contentType), (String)request.readBody());
        }
        return RequestBody.create(null, (byte[])new byte[0]);
    }

    @Override
    public void close() throws Exception {
    }
}

