/*
 * Decompiled with CFR 0.152.
 */
package cloud.genesys.webmessaging.sdk.api.request;

import cloud.genesys.webmessaging.sdk.ApiRequest;
import cloud.genesys.webmessaging.sdk.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetWebmessagingMessagesRequest {
    private Integer pageSize;
    private Integer pageNumber;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public GetWebmessagingMessagesRequest withPageSize(Integer pageSize) {
        this.setPageSize(pageSize);
        return this;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public GetWebmessagingMessagesRequest withPageNumber(Integer pageNumber) {
        this.setPageNumber(pageNumber);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetWebmessagingMessagesRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        return ApiRequestBuilder.create("GET", "/api/v2/webmessaging/messages").withQueryParameters("pageSize", "", this.pageSize).withQueryParameters("pageNumber", "", this.pageNumber).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames(new String[0]).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final GetWebmessagingMessagesRequest request = new GetWebmessagingMessagesRequest();

        private Builder() {
        }

        public Builder withPageSize(Integer pageSize) {
            this.request.setPageSize(pageSize);
            return this;
        }

        public Builder withPageNumber(Integer pageNumber) {
            this.request.setPageNumber(pageNumber);
            return this;
        }

        public GetWebmessagingMessagesRequest build() {
            return this.request;
        }
    }
}

