/*
 * Decompiled with CFR 0.152.
 */
package cloud.eppo.ufc.dto.adapters;

import cloud.eppo.Utils;
import cloud.eppo.model.ShardRange;
import cloud.eppo.ufc.dto.Allocation;
import cloud.eppo.ufc.dto.EppoValue;
import cloud.eppo.ufc.dto.FlagConfig;
import cloud.eppo.ufc.dto.FlagConfigResponse;
import cloud.eppo.ufc.dto.OperatorType;
import cloud.eppo.ufc.dto.Shard;
import cloud.eppo.ufc.dto.Split;
import cloud.eppo.ufc.dto.TargetingCondition;
import cloud.eppo.ufc.dto.TargetingRule;
import cloud.eppo.ufc.dto.Variation;
import cloud.eppo.ufc.dto.VariationType;
import cloud.eppo.ufc.dto.adapters.EppoValueDeserializer;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlagConfigResponseDeserializer
extends StdDeserializer<FlagConfigResponse> {
    private static final Logger log = LoggerFactory.getLogger(FlagConfigResponseDeserializer.class);
    private final EppoValueDeserializer eppoValueDeserializer = new EppoValueDeserializer();

    protected FlagConfigResponseDeserializer(Class<?> vc) {
        super(vc);
    }

    public FlagConfigResponseDeserializer() {
        this(null);
    }

    public FlagConfigResponse deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JacksonException {
        JsonNode rootElement = (JsonNode)jp.getCodec().readTree(jp);
        if (rootElement == null || !rootElement.isObject()) {
            log.warn("no top-level JSON object");
            return new FlagConfigResponse();
        }
        ObjectNode rootObject = (ObjectNode)rootElement;
        JsonNode flagsElement = rootObject.get("flags");
        if (flagsElement == null) {
            log.warn("no root-level flags property");
            return new FlagConfigResponse();
        }
        ConcurrentHashMap<String, FlagConfig> flags = new ConcurrentHashMap<String, FlagConfig>();
        ObjectNode flagsObject = (ObjectNode)flagsElement;
        for (Map.Entry flagEntry : flagsObject.properties()) {
            FlagConfig flagConfig = this.deserializeFlag((JsonNode)flagEntry.getValue(), ctxt);
            flags.put((String)flagEntry.getKey(), flagConfig);
        }
        return new FlagConfigResponse(flags);
    }

    private FlagConfig deserializeFlag(JsonNode jsonNode, DeserializationContext context) {
        String key = jsonNode.get("key").asText();
        boolean enabled = jsonNode.get("enabled").asBoolean();
        int totalShards = jsonNode.get("totalShards").asInt();
        VariationType variationType = VariationType.fromString(jsonNode.get("variationType").asText());
        Map<String, Variation> variations = this.deserializeVariations(jsonNode.get("variations"), context);
        List<Allocation> allocations = this.deserializeAllocations(jsonNode.get("allocations"), context);
        return new FlagConfig(key, enabled, totalShards, variationType, variations, allocations);
    }

    private Map<String, Variation> deserializeVariations(JsonNode jsonNode, DeserializationContext context) {
        HashMap<String, Variation> variations = new HashMap<String, Variation>();
        if (jsonNode == null) {
            return variations;
        }
        Iterator it = jsonNode.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String key = ((JsonNode)entry.getValue()).get("key").asText();
            EppoValue value = this.eppoValueDeserializer.deserializeNode(((JsonNode)entry.getValue()).get("value"));
            variations.put((String)entry.getKey(), new Variation(key, value));
        }
        return variations;
    }

    private List<Allocation> deserializeAllocations(JsonNode jsonNode, DeserializationContext ctxt) {
        ArrayList<Allocation> allocations = new ArrayList<Allocation>();
        if (jsonNode == null) {
            return allocations;
        }
        for (JsonNode allocationNode : jsonNode) {
            String key = allocationNode.get("key").asText();
            Set<TargetingRule> rules = this.deserializeTargetingRules(allocationNode.get("rules"), ctxt);
            Date startAt = Utils.parseUtcISODateElement(allocationNode.get("startAt"));
            Date endAt = Utils.parseUtcISODateElement(allocationNode.get("endAt"));
            List<Split> splits = this.deserializeSplits(allocationNode.get("splits"));
            boolean doLog = allocationNode.get("doLog").asBoolean();
            allocations.add(new Allocation(key, rules, startAt, endAt, splits, doLog));
        }
        return allocations;
    }

    private Set<TargetingRule> deserializeTargetingRules(JsonNode jsonNode, DeserializationContext context) {
        HashSet<TargetingRule> targetingRules = new HashSet<TargetingRule>();
        if (jsonNode == null || !jsonNode.isArray()) {
            return targetingRules;
        }
        for (JsonNode ruleNode : jsonNode) {
            HashSet<TargetingCondition> conditions = new HashSet<TargetingCondition>();
            for (JsonNode conditionNode : ruleNode.get("conditions")) {
                String attribute = conditionNode.get("attribute").asText();
                String operatorKey = conditionNode.get("operator").asText();
                OperatorType operator = OperatorType.fromString(operatorKey);
                if (operator == null) {
                    log.warn("Unknown operator \"{}\"", (Object)operatorKey);
                    continue;
                }
                EppoValue value = this.eppoValueDeserializer.deserializeNode(conditionNode.get("value"));
                conditions.add(new TargetingCondition(operator, attribute, value));
            }
            targetingRules.add(new TargetingRule(conditions));
        }
        return targetingRules;
    }

    private List<Split> deserializeSplits(JsonNode jsonNode) {
        ArrayList<Split> splits = new ArrayList<Split>();
        if (jsonNode == null || !jsonNode.isArray()) {
            return splits;
        }
        for (JsonNode splitNode : jsonNode) {
            String variationKey = splitNode.get("variationKey").asText();
            Set<Shard> shards = this.deserializeShards(splitNode.get("shards"));
            HashMap<String, String> extraLogging = new HashMap<String, String>();
            JsonNode extraLoggingNode = splitNode.get("extraLogging");
            if (extraLoggingNode != null && extraLoggingNode.isObject()) {
                Iterator it = extraLoggingNode.fields();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    extraLogging.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
                }
            }
            splits.add(new Split(variationKey, shards, extraLogging));
        }
        return splits;
    }

    private Set<Shard> deserializeShards(JsonNode jsonNode) {
        HashSet<Shard> shards = new HashSet<Shard>();
        if (jsonNode == null || !jsonNode.isArray()) {
            return shards;
        }
        for (JsonNode shardNode : jsonNode) {
            String salt = shardNode.get("salt").asText();
            HashSet<ShardRange> ranges = new HashSet<ShardRange>();
            for (JsonNode rangeNode : shardNode.get("ranges")) {
                int start = rangeNode.get("start").asInt();
                int end = rangeNode.get("end").asInt();
                ranges.add(new ShardRange(start, end));
            }
            shards.add(new Shard(salt, ranges));
        }
        return shards;
    }
}

