/*
 * Decompiled with CFR 0.152.
 */
package cloud.eppo.ufc.dto.adapters;

import cloud.eppo.ufc.dto.EppoValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EppoValueDeserializer
extends StdDeserializer<EppoValue> {
    private static final Logger log = LoggerFactory.getLogger(EppoValueDeserializer.class);

    protected EppoValueDeserializer(Class<?> vc) {
        super(vc);
    }

    public EppoValueDeserializer() {
        this(null);
    }

    public EppoValue deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return this.deserializeNode((JsonNode)jp.getCodec().readTree(jp));
    }

    public EppoValue deserializeNode(JsonNode node) {
        EppoValue result;
        if (node == null || node.isNull()) {
            result = EppoValue.nullValue();
        } else if (node.isArray()) {
            ArrayList<String> stringArray = new ArrayList<String>();
            for (JsonNode arrayElement : node) {
                if (arrayElement.isValueNode() && arrayElement.isTextual()) {
                    stringArray.add(arrayElement.asText());
                    continue;
                }
                log.warn("only Strings are supported for array-valued values; received: {}", (Object)arrayElement);
            }
            result = EppoValue.valueOf(stringArray);
        } else if (node.isValueNode()) {
            result = node.isBoolean() ? EppoValue.valueOf(node.asBoolean()) : (node.isNumber() ? EppoValue.valueOf(node.doubleValue()) : EppoValue.valueOf(node.textValue()));
        } else {
            log.warn("Unexpected JSON for parsing a value: {}", (Object)node);
            result = EppoValue.nullValue();
        }
        return result;
    }
}

