/*
 * Decompiled with CFR 0.152.
 */
package cloud.eppo.rac.dto;

import cloud.eppo.rac.dto.Allocation;
import cloud.eppo.rac.dto.EppoValue;
import cloud.eppo.rac.dto.Rule;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExperimentConfiguration {
    private final String name;
    private final boolean enabled;
    private final int subjectShards;
    private final Map<String, EppoValue> typedOverrides = new HashMap<String, EppoValue>();
    private final Map<String, Allocation> allocations;
    private final List<Rule> rules;

    @JsonCreator
    public ExperimentConfiguration(@JsonProperty(value="name") String name, @JsonProperty(value="enabled") boolean enabled, @JsonProperty(value="subjectShards") int subjectShards, @JsonProperty(value="allocations") Map<String, Allocation> allocations, @JsonProperty(value="rules") List<Rule> rules) {
        this.name = name;
        this.enabled = enabled;
        this.subjectShards = subjectShards;
        this.allocations = allocations;
        this.rules = rules;
    }

    public Allocation getAllocation(String allocationKey) {
        return this.allocations.get(allocationKey);
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getSubjectShards() {
        return this.subjectShards;
    }

    public Map<String, EppoValue> getTypedOverrides() {
        return this.typedOverrides;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public Map<String, Allocation> getAllocations() {
        return this.allocations;
    }
}

