/*
 * Decompiled with CFR 0.152.
 */
package cloud.eppo.rac.dto;

import cloud.eppo.rac.dto.AttributeCoefficients;
import cloud.eppo.rac.dto.EppoValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanditNumericAttributeCoefficients
implements AttributeCoefficients {
    private final Logger logger = LoggerFactory.getLogger(BanditNumericAttributeCoefficients.class);
    private final String attributeKey;
    private final Double coefficient;
    private final Double missingValueCoefficient;

    public BanditNumericAttributeCoefficients(String attributeKey, Double coefficient, Double missingValueCoefficient) {
        this.attributeKey = attributeKey;
        this.coefficient = coefficient;
        this.missingValueCoefficient = missingValueCoefficient;
    }

    @Override
    public double scoreForAttributeValue(EppoValue attributeValue) {
        if (attributeValue == null || attributeValue.isNull()) {
            return this.missingValueCoefficient;
        }
        if (!attributeValue.isNumeric()) {
            this.logger.warn("Unexpected categorical attribute value for attribute {}", (Object)this.attributeKey);
        }
        return this.coefficient * attributeValue.doubleValue();
    }

    @Override
    public String getAttributeKey() {
        return this.attributeKey;
    }

    public Double getCoefficient() {
        return this.coefficient;
    }

    public Double getMissingValueCoefficient() {
        return this.missingValueCoefficient;
    }
}

