/*
 * Decompiled with CFR 0.152.
 */
package cloud.eppo.rac.dto;

import cloud.eppo.rac.dto.AttributeCoefficients;
import cloud.eppo.rac.dto.EppoValue;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanditCategoricalAttributeCoefficients
implements AttributeCoefficients {
    private final Logger logger = LoggerFactory.getLogger(BanditCategoricalAttributeCoefficients.class);
    private final String attributeKey;
    private final Double missingValueCoefficient;
    private final Map<String, Double> valueCoefficients;

    public BanditCategoricalAttributeCoefficients(String attributeKey, Double missingValueCoefficient, Map<String, Double> valueCoefficients) {
        this.attributeKey = attributeKey;
        this.missingValueCoefficient = missingValueCoefficient;
        this.valueCoefficients = valueCoefficients;
    }

    @Override
    public double scoreForAttributeValue(EppoValue attributeValue) {
        if (attributeValue == null || attributeValue.isNull()) {
            return this.missingValueCoefficient;
        }
        if (attributeValue.isNumeric()) {
            this.logger.warn("Unexpected numeric attribute value for attribute {}", (Object)this.attributeKey);
            return this.missingValueCoefficient;
        }
        String valueKey = attributeValue.toString();
        Double coefficient = this.valueCoefficients.get(valueKey);
        return coefficient != null ? coefficient : this.missingValueCoefficient;
    }

    @Override
    public String getAttributeKey() {
        return this.attributeKey;
    }

    public Double getMissingValueCoefficient() {
        return this.missingValueCoefficient;
    }

    public Map<String, Double> getValueCoefficients() {
        return this.valueCoefficients;
    }
}

