/*
 * Decompiled with CFR 0.152.
 */
package cloud.eppo.rac.deserializer;

import cloud.eppo.rac.dto.EppoValue;
import cloud.eppo.rac.exception.UnsupportedEppoValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.util.ArrayList;

public class EppoValueDeserializer
extends StdDeserializer<EppoValue> {
    public EppoValueDeserializer() {
        this((Class)null);
    }

    protected EppoValueDeserializer(Class<?> vc) {
        super(vc);
    }

    protected EppoValueDeserializer(JavaType valueType) {
        super(valueType);
    }

    protected EppoValueDeserializer(StdDeserializer<?> src) {
        super(src);
    }

    public EppoValue deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        return this.parseEppoValue(node);
    }

    private EppoValue parseEppoValue(JsonNode node) {
        switch (node.getNodeType()) {
            case ARRAY: {
                ArrayList<String> array = new ArrayList<String>();
                if (node.size() == 0) {
                    return EppoValue.valueOf(new ArrayList<String>());
                }
                if (node.get(0).getNodeType() != JsonNodeType.STRING) {
                    throw new UnsupportedEppoValue("Unsupported Eppo Values");
                }
                for (int i = 0; i < node.size(); ++i) {
                    array.add(node.get(i).asText());
                }
                return EppoValue.valueOf(array);
            }
            case NUMBER: {
                return EppoValue.valueOf(node.asDouble());
            }
            case STRING: {
                return EppoValue.valueOf(node.asText());
            }
            case BOOLEAN: {
                return EppoValue.valueOf(node.asBoolean());
            }
            case OBJECT: 
            case POJO: {
                return EppoValue.valueOf(node);
            }
        }
        return EppoValue.nullValue();
    }
}

