/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.kaptcha.kaptcha;

import cloud.agileframework.kaptcha.properties.KaptchaConfigProperties;
import com.google.code.kaptcha.text.TextProducer;
import com.google.code.kaptcha.util.Configurable;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class AgileTextProducer
extends Configurable
implements TextProducer {
    @Autowired
    private static KaptchaConfigProperties kaptchaConfigProperties;
    private final SecureRandom random = SecureRandom.getInstanceStrong();

    public static void setKaptchaConfigProperties(KaptchaConfigProperties kaptchaConfigProperties) {
        AgileTextProducer.kaptchaConfigProperties = kaptchaConfigProperties;
    }

    public String getText() {
        int length = this.getConfig().getTextProducerCharLength();
        assert (kaptchaConfigProperties != null);
        String text = kaptchaConfigProperties.getText();
        if (StringUtils.isEmpty((Object)text)) {
            return this.defaultGetText();
        }
        char[] s = text.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int ind = this.random.nextInt(s.length);
            sb.append(s[ind]);
        }
        return sb.toString();
    }

    private String defaultGetText() {
        int length = this.getConfig().getTextProducerCharLength();
        char[] chars = this.getConfig().getTextProducerCharString();
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            text.append(chars[this.random.nextInt(chars.length)]);
        }
        return text.toString();
    }
}

