/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.kaptcha.config;

import cloud.agileframework.kaptcha.kaptcha.AgileTextProducer;
import cloud.agileframework.kaptcha.kaptcha.KaptchaContextHolder;
import cloud.agileframework.kaptcha.kaptcha.KaptchaServlet;
import cloud.agileframework.kaptcha.properties.KaptchaConfigProperties;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={KaptchaConfigProperties.class})
@ConditionalOnClass(value={DefaultKaptcha.class})
@ConditionalOnProperty(name={"enable"}, prefix="agile.kaptcha", havingValue="true")
public class KaptchaAutoConfiguration
implements InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(KaptchaAutoConfiguration.class);
    private final KaptchaConfigProperties kaptchaConfigProperties;

    public KaptchaAutoConfiguration(KaptchaConfigProperties kaptchaConfigProperties) {
        this.kaptchaConfigProperties = kaptchaConfigProperties;
        AgileTextProducer.setKaptchaConfigProperties(kaptchaConfigProperties);
    }

    @Bean
    public ServletRegistrationBean<HttpServlet> kaptchaServlet() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u5b8c\u6210\u521d\u59cb\u5316\u767b\u5f55\u9a8c\u8bc1\u7801");
        }
        ServletRegistrationBean reg = new ServletRegistrationBean();
        reg.setServlet((Servlet)new KaptchaServlet());
        reg.addUrlMappings(new String[]{this.kaptchaConfigProperties.getUrl()});
        return reg;
    }

    @Bean
    DefaultKaptcha defaultKaptcha() {
        DefaultKaptcha defaultKaptcha = new DefaultKaptcha();
        defaultKaptcha.setConfig(new Config(this.kaptchaConfigProperties.getProperties()));
        return defaultKaptcha;
    }

    public void afterPropertiesSet() {
        KaptchaContextHolder.initConfig(this.kaptchaConfigProperties);
    }
}

