/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.shell;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShellUtil {
    private static final Log log = LogFactory.getLog(ShellUtil.class);
    private static final String ERROR_LOG = "\u6267\u884c\u547d\u4ee4\u65f6\u53d1\u751f\u5f02\u5e38";
    private static final ExecutorService POOL = new ThreadPoolExecutor(3, 3, 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
    public static final String NEW_LINE = "\n";

    private ShellUtil() {
    }

    public static Result execOut(String command) {
        return ShellUtil.execOut(null, null, command, 1L, TimeUnit.MINUTES);
    }

    public static Result execOut(String ... commands) {
        return ShellUtil.execOut(null, null, commands, 1L, TimeUnit.MINUTES);
    }

    public static Result execOut(String[] env, String ... commands) {
        return ShellUtil.execOut(env, null, commands, 1L, TimeUnit.MINUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result execOut(String[] env, File dir, String command, long timout, TimeUnit unit) {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(command, env, dir);
            Result result = ShellUtil.getResult(process, timout, unit);
            return result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error((Object)ERROR_LOG, (Throwable)e);
            Result result = new Result(false, e.getMessage());
            return result;
        }
        catch (IOException | ExecutionException e) {
            log.error((Object)ERROR_LOG, (Throwable)e);
            Result result = new Result(false, e.getMessage());
            return result;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result execOut(String[] env, File dir, String[] commands, long timout, TimeUnit unit) {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(commands, env, dir);
            Result result = ShellUtil.getResult(process, timout, unit);
            return result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error((Object)ERROR_LOG, (Throwable)e);
            Result result = new Result(false, e.getMessage());
            return result;
        }
        catch (IOException | ExecutionException e) {
            log.error((Object)ERROR_LOG, (Throwable)e);
            Result result = new Result(false, e.getMessage());
            return result;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    public static Result batchExecOut(String ... commands) {
        return ShellUtil.batchExecOut(null, null, commands, 1L, TimeUnit.MINUTES);
    }

    public static Result batchExecOut(String[] env, String ... commands) {
        return ShellUtil.batchExecOut(env, null, commands, 1L, TimeUnit.MINUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result batchExecOut(String[] env, File dir, String[] commands, long timeout, TimeUnit unit) {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(commands[0], env, dir);
            OutputStream outputStream = process.getOutputStream();
            for (int i = 1; i < commands.length; ++i) {
                if (commands[i] == null) continue;
                outputStream.write(commands[i].getBytes());
                outputStream.write(NEW_LINE.getBytes());
            }
            outputStream.flush();
            outputStream.close();
            Result result = ShellUtil.getResult(process, timeout, unit);
            return result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error((Object)ERROR_LOG, (Throwable)e);
            Result result = new Result(false, e.getMessage());
            return result;
        }
        catch (IOException | ExecutionException e) {
            log.error((Object)ERROR_LOG, (Throwable)e);
            Result result = new Result(false, e.getMessage());
            return result;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    private static Result getResult(Process process, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
        CompletableFuture<String> successLog = CompletableFuture.supplyAsync(() -> {
            try {
                return IOUtils.toString((InputStream)process.getInputStream(), (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, POOL);
        CompletableFuture<String> errorLog = CompletableFuture.supplyAsync(() -> {
            try {
                return IOUtils.toString((InputStream)process.getInputStream(), (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, POOL);
        CompletableFuture<Boolean> main = CompletableFuture.supplyAsync(() -> {
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
            return process.exitValue() == 0;
        });
        boolean isSuccess = false;
        try {
            isSuccess = main.get(timeout, unit);
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        if (isSuccess) {
            return new Result(true, successLog.get());
        }
        return new Result(true, errorLog.get());
    }

    public static boolean exec(String command) {
        return ShellUtil.exec(null, null, command, 1L, TimeUnit.MINUTES);
    }

    public static boolean exec(String ... commands) {
        return ShellUtil.exec(null, null, commands, 1L, TimeUnit.MINUTES);
    }

    public static boolean exec(String[] env, String command) {
        return ShellUtil.exec(env, null, command, 1L, TimeUnit.MINUTES);
    }

    public static boolean exec(String[] env, File dir, String command, long timeout, TimeUnit unit) {
        try {
            Process process = Runtime.getRuntime().exec(command, env, dir);
            Future<Boolean> waitFuture = POOL.submit(() -> {
                process.waitFor();
                return process.exitValue() == 0;
            });
            return waitFuture.get(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error((Object)ERROR_LOG, (Throwable)e);
        }
        catch (IOException | ExecutionException | TimeoutException e) {
            log.error((Object)ERROR_LOG, (Throwable)e);
        }
        return false;
    }

    public static boolean exec(String[] env, File dir, String[] commands, long timeout, TimeUnit unit) {
        try {
            Process process = Runtime.getRuntime().exec(commands, env, dir);
            Future<Boolean> waitFuture = POOL.submit(() -> {
                process.waitFor();
                return process.exitValue() == 0;
            });
            return waitFuture.get(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error((Object)ERROR_LOG, (Throwable)e);
        }
        catch (IOException | ExecutionException | TimeoutException e) {
            log.error((Object)ERROR_LOG, (Throwable)e);
        }
        return false;
    }

    public static boolean batchExec(String ... commands) {
        return ShellUtil.batchExec(null, null, commands, 1L, TimeUnit.MINUTES);
    }

    public static boolean batchExec(String[] env, String ... commands) {
        return ShellUtil.batchExec(env, null, commands, 1L, TimeUnit.MINUTES);
    }

    public static boolean batchExec(String[] env, File dir, String[] commands, long timeout, TimeUnit unit) {
        try {
            Process process = Runtime.getRuntime().exec(commands[0], env, dir);
            OutputStream outputStream = process.getOutputStream();
            for (int i = 1; i < commands.length; ++i) {
                if (commands[i] == null) continue;
                outputStream.write(commands[i].getBytes());
                outputStream.write(NEW_LINE.getBytes());
            }
            outputStream.flush();
            outputStream.close();
            Future<Boolean> waitFuture = POOL.submit(() -> {
                process.waitFor();
                return process.exitValue() == 0;
            });
            return waitFuture.get(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error((Object)ERROR_LOG, (Throwable)e);
        }
        catch (IOException | ExecutionException | TimeoutException e) {
            log.error((Object)ERROR_LOG, (Throwable)e);
        }
        return false;
    }

    public static class Result {
        private final boolean success;
        private final String log;

        public Result(boolean success, String log) {
            this.success = success;
            this.log = log;
        }

        public boolean success() {
            return this.success;
        }

        public String log() {
            return this.log;
        }
    }
}

