/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.security;

import cloud.agileframework.common.util.bytes.ByteUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.function.Function;
import javax.crypto.Cipher;
import org.apache.commons.io.FileUtils;

public class KeyUtil {
    private static final String UNENCRYPTED_KEY_HEADER = "-----BEGIN KEY-----";
    private static final String UNENCRYPTED_KEY_FOOTER = "-----END KEY-----";
    private static final String ENCRYPTED_KEY_HEADER = "-----BEGIN ENCRYPTED KEY-----";
    private static final String ENCRYPTED_KEY_FOOTER = "-----END ENCRYPTED KEY-----";
    private static final String UNENCRYPTED_PRIVATE_KEY_HEADER = "-----BEGIN PRIVATE KEY-----";
    private static final String UNENCRYPTED_PRIVATE_KEY_FOOTER = "-----END PRIVATE KEY-----";
    private static final String ENCRYPTED_PRIVATE_KEY_HEADER = "-----BEGIN ENCRYPTED PRIVATE KEY-----";
    private static final String ENCRYPTED_PRIVATE_KEY_FOOTER = "-----END ENCRYPTED PRIVATE KEY-----";
    private static final String UNENCRYPTED_PUBLIC_KEY_HEADER = "-----BEGIN PUBLIC KEY-----";
    private static final String UNENCRYPTED_PUBLIC_KEY_FOOTER = "-----END PUBLIC KEY-----";
    private static final String ENCRYPTED_PUBLIC_KEY_HEADER = "-----BEGIN ENCRYPTED PUBLIC KEY-----";
    private static final String ENCRYPTED_PUBLIC_KEY_FOOTER = "-----END ENCRYPTED PUBLIC KEY-----";

    public static String toString(Key key, boolean encrypt) {
        byte[] bytes = key.getEncoded();
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        if (encrypt) {
            return ByteUtil.encryptionToString(bytes);
        }
        return ByteUtil.toBase64(bytes);
    }

    public static Key readFile(File file, Function<byte[], Key> byteToKey) {
        String content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        return KeyUtil.contentToKey(content, byteToKey);
    }

    public static Key contentToKey(String content, Function<byte[], Key> byteToKey) {
        byte[] contentByte;
        if (content.contains(UNENCRYPTED_PRIVATE_KEY_HEADER)) {
            String privateContent = KeyUtil.getContent(content, UNENCRYPTED_PRIVATE_KEY_HEADER, UNENCRYPTED_PRIVATE_KEY_FOOTER);
            contentByte = ByteUtil.toByte(privateContent);
        } else if (content.contains(ENCRYPTED_PRIVATE_KEY_HEADER)) {
            String privateContent = KeyUtil.getContent(content, ENCRYPTED_PRIVATE_KEY_HEADER, ENCRYPTED_PRIVATE_KEY_FOOTER);
            contentByte = ByteUtil.decrypt(privateContent);
        } else if (content.contains(UNENCRYPTED_PUBLIC_KEY_HEADER)) {
            String publicContent = KeyUtil.getContent(content, UNENCRYPTED_PUBLIC_KEY_HEADER, UNENCRYPTED_PUBLIC_KEY_FOOTER);
            contentByte = ByteUtil.toByte(publicContent);
        } else if (content.contains(ENCRYPTED_PUBLIC_KEY_HEADER)) {
            String publicContent = KeyUtil.getContent(content, ENCRYPTED_PUBLIC_KEY_HEADER, ENCRYPTED_PUBLIC_KEY_FOOTER);
            contentByte = ByteUtil.decrypt(publicContent);
        } else if (content.contains(UNENCRYPTED_KEY_HEADER)) {
            String publicContent = KeyUtil.getContent(content, UNENCRYPTED_KEY_HEADER, UNENCRYPTED_KEY_FOOTER);
            contentByte = ByteUtil.toByte(publicContent);
        } else if (content.contains(ENCRYPTED_KEY_HEADER)) {
            String publicContent = KeyUtil.getContent(content, ENCRYPTED_KEY_HEADER, ENCRYPTED_KEY_FOOTER);
            contentByte = ByteUtil.decrypt(publicContent);
        } else {
            return null;
        }
        return byteToKey.apply(contentByte);
    }

    private static String getContent(String content, String start, String end) {
        return content.substring(content.indexOf(start) + start.length(), content.indexOf(end)).replaceAll("\\s", "");
    }

    public static String toContent(Key key, boolean encrypt) {
        String content = KeyUtil.toString(key, encrypt);
        StringBuilder builder = new StringBuilder();
        if (key instanceof PrivateKey && encrypt) {
            KeyUtil.format(content, builder, ENCRYPTED_PRIVATE_KEY_HEADER, ENCRYPTED_PRIVATE_KEY_FOOTER);
        } else if (key instanceof PrivateKey) {
            KeyUtil.format(content, builder, UNENCRYPTED_PRIVATE_KEY_HEADER, UNENCRYPTED_PRIVATE_KEY_FOOTER);
        } else if (key instanceof PublicKey && encrypt) {
            KeyUtil.format(content, builder, ENCRYPTED_PUBLIC_KEY_HEADER, ENCRYPTED_PUBLIC_KEY_FOOTER);
        } else if (key instanceof PublicKey) {
            KeyUtil.format(content, builder, UNENCRYPTED_PUBLIC_KEY_HEADER, UNENCRYPTED_PUBLIC_KEY_FOOTER);
        } else if (encrypt) {
            KeyUtil.format(content, builder, ENCRYPTED_KEY_HEADER, ENCRYPTED_KEY_FOOTER);
        } else {
            KeyUtil.format(content, builder, UNENCRYPTED_KEY_HEADER, UNENCRYPTED_KEY_FOOTER);
        }
        return builder.toString();
    }

    private static void format(String content, StringBuilder builder, String start, String end) {
        builder.append(start);
        builder.append("\n");
        builder.append(content);
        builder.append("\n");
        builder.append(end);
    }

    public static byte[] encrypt(byte[] text, Key key, String algorithm) {
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(1, key);
        return cipher.doFinal(text);
    }

    public static byte[] decrypt(byte[] text, Key key, String algorithm) {
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(2, key);
        return cipher.doFinal(text);
    }
}

