/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.rsa;

import cloud.agileframework.common.util.bytes.ByteUtil;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.lang3.ArrayUtils;

public class RSAUtil {
    private static final String RSA = "RSA";
    private static final String SPLIT = "$=ACs13fz/";

    public static KeyPair toKeyPair(String text) {
        if (text == null || !text.contains(SPLIT)) {
            return null;
        }
        String content = text.substring(0, text.indexOf(SPLIT));
        String publicLengthStr = text.substring(text.indexOf(SPLIT) + SPLIT.length());
        int publicLength = Integer.parseInt(publicLengthStr);
        byte[] keyPairBytes = ByteUtil.toByte(content);
        byte[] publicKeyBytes = ByteUtil.decrypt(ArrayUtils.subarray((byte[])keyPairBytes, (int)(keyPairBytes.length - publicLength), (int)keyPairBytes.length));
        byte[] privateKeyBytes = ByteUtil.decrypt(ArrayUtils.subarray((byte[])keyPairBytes, (int)0, (int)(keyPairBytes.length - publicLength)));
        return new KeyPair(RSAUtil.toPublicKey(publicKeyBytes), RSAUtil.toPrivateKey(privateKeyBytes));
    }

    public static String toString(KeyPair keyPair) {
        byte[] publicKeyBytes = ByteUtil.encryption(keyPair.getPublic().getEncoded());
        byte[] privateKeyBytes = ByteUtil.encryption(keyPair.getPrivate().getEncoded());
        byte[] keyPairBytes = new byte[publicKeyBytes.length + privateKeyBytes.length];
        int index = 0;
        for (byte b : privateKeyBytes) {
            keyPairBytes[index++] = b;
        }
        for (byte b : publicKeyBytes) {
            keyPairBytes[index++] = b;
        }
        return ByteUtil.toBase64(keyPairBytes) + SPLIT + publicKeyBytes.length;
    }

    public static RSAPublicKey toPublicKey(byte[] text) {
        return (RSAPublicKey)KeyFactory.getInstance(RSA).generatePublic(new X509EncodedKeySpec(text));
    }

    public static RSAPrivateKey toPrivateKey(byte[] text) {
        return (RSAPrivateKey)KeyFactory.getInstance(RSA).generatePrivate(new PKCS8EncodedKeySpec(text));
    }
}

