/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.pattern;

import cloud.agileframework.common.util.string.StringUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternUtil {
    public static Matcher getMatcher(String text, Pattern compile) {
        return compile.matcher(text);
    }

    public static boolean matches(String regex, String text, int flags) {
        Matcher matcher = PatternUtil.getMatcher(text, Pattern.compile(regex, flags));
        return matcher.matches();
    }

    public static boolean matches(String regex, String text) {
        Matcher matcher = PatternUtil.getMatcher(text, Pattern.compile(regex));
        return matcher.matches();
    }

    public static boolean find(String regex, String text, int flags) {
        Matcher matcher = PatternUtil.getMatcher(text, Pattern.compile(regex, flags));
        return matcher.find();
    }

    public static boolean find(String regex, String text) {
        Matcher matcher = PatternUtil.getMatcher(text, Pattern.compile(regex));
        return matcher.find();
    }

    public static List<String> getMatched(String regex, String text, int flags) {
        Matcher matcher = PatternUtil.getMatcher(text, Pattern.compile(regex, flags));
        ArrayList list = Lists.newArrayList();
        while (matcher.find()) {
            list.add(matcher.group());
        }
        return list;
    }

    public static String getMatchedString(String regex, String text, int index) {
        Matcher matcher = PatternUtil.getMatcher(text, Pattern.compile(regex, 0));
        int i = 0;
        while (matcher.find()) {
            if (i == index) {
                return matcher.group();
            }
            ++i;
        }
        return null;
    }

    public static List<String> getMatched(String regex, String text) {
        return PatternUtil.getMatched(regex, text, 0);
    }

    public static Map<String, String> getGroups(String regex, String text) {
        List<String> groupNames = PatternUtil.getMatched("(?<=<)[\\w]+(?=>)", regex);
        Matcher matcher = PatternUtil.getMatcher(text, Pattern.compile(regex));
        if (matcher.find() && groupNames.size() > 0) {
            HashMap result = Maps.newHashMapWithExpectedSize((int)groupNames.size());
            for (String key : groupNames) {
                result.put(key, matcher.group(key));
            }
            return result;
        }
        return Maps.newHashMap();
    }

    public static String[] getMatchedString(String regex, String text) {
        Matcher matcher = PatternUtil.getMatcher(text, Pattern.compile(regex));
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            sb.append(matcher.group()).append(",");
        }
        if (StringUtil.isEmpty((CharSequence)sb.toString())) {
            return null;
        }
        return sb.toString().split(",");
    }

    public static String getGroupString(String regex, String text, int index) {
        Matcher matcher = PatternUtil.getMatcher(text, Pattern.compile(regex));
        int count = matcher.groupCount();
        if (count > 0 && matcher.find()) {
            return matcher.group(index);
        }
        return null;
    }

    public static LinkedList<String> getGroupString(String regex, String text) {
        Matcher matcher = PatternUtil.getMatcher(text, Pattern.compile(regex));
        int count = matcher.groupCount();
        if (count > 0) {
            LinkedList<String> temp = new LinkedList<String>();
            if (matcher.find()) {
                for (int i = 1; i < count + 1; ++i) {
                    temp.add(matcher.group(i));
                }
            }
            return temp;
        }
        return null;
    }

    public static int lastIndexOf(String regex, String text) {
        Matcher matcher = PatternUtil.getMatcher(text, Pattern.compile(regex));
        int endIndex = -1;
        while (matcher.find()) {
            endIndex = matcher.start();
        }
        return endIndex;
    }

    public static int indexOf(String regex, String text) {
        Matcher matcher = PatternUtil.getMatcher(text, Pattern.compile(regex));
        int endIndex = -1;
        if (matcher.find()) {
            endIndex = matcher.start();
        }
        return endIndex;
    }
}

