/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.object;

import cloud.agileframework.common.util.object.DifferentField;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;

public class DifferentRefField
extends DifferentField {
    private List<DifferentField> ref;
    private boolean ignoreParentName;
    private boolean ignoreParentRemark;

    public DifferentRefField(String propertyName, String propertyRemark, Class<?> propertyType, List<DifferentField> ref, boolean ignoreParentName, boolean ignoreParentRemark) {
        super(propertyName, propertyRemark, propertyType);
        this.ref = ref;
        this.ignoreParentName = ignoreParentName;
        this.ignoreParentRemark = ignoreParentRemark;
    }

    public List<DifferentField> extractRef() {
        if (this.ref == null) {
            return Lists.newArrayList();
        }
        if (this.ref.isEmpty()) {
            return this.ref;
        }
        return this.ref.stream().map(r -> {
            if (!this.ignoreParentName) {
                String parentFieldName = this.getFieldName();
                String currentFieldName = r.getFieldName();
                r.setFieldName(parentFieldName + "." + currentFieldName);
            }
            if (!this.ignoreParentRemark) {
                String currentFieldRemark;
                String parentFieldRemark = this.getFieldRemark();
                if (parentFieldRemark == null) {
                    parentFieldRemark = this.getFieldName();
                }
                if ((currentFieldRemark = r.getFieldRemark()) == null) {
                    currentFieldRemark = r.getFieldName();
                }
                r.setFieldRemark(parentFieldRemark + "." + currentFieldRemark);
            }
            return r;
        }).collect(Collectors.toList());
    }

    @Override
    public String describe() {
        StringBuilder desc = new StringBuilder(this.getFieldRemark() == null ? this.getFieldName() : this.getFieldRemark()).append(":");
        if (this.ref != null && !this.ref.isEmpty()) {
            String refDesc = this.ref.stream().map(DifferentField::describe).collect(Collectors.joining("\n"));
            desc.append(refDesc);
        }
        return desc.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DifferentRefField)) {
            return false;
        }
        DifferentRefField other = (DifferentRefField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isIgnoreParentName() != other.isIgnoreParentName()) {
            return false;
        }
        if (this.isIgnoreParentRemark() != other.isIgnoreParentRemark()) {
            return false;
        }
        List<DifferentField> this$ref = this.getRef();
        List<DifferentField> other$ref = other.getRef();
        return !(this$ref == null ? other$ref != null : !((Object)this$ref).equals(other$ref));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DifferentRefField;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isIgnoreParentName() ? 79 : 97);
        result = result * 59 + (this.isIgnoreParentRemark() ? 79 : 97);
        List<DifferentField> $ref = this.getRef();
        result = result * 59 + ($ref == null ? 43 : ((Object)$ref).hashCode());
        return result;
    }

    public List<DifferentField> getRef() {
        return this.ref;
    }

    public boolean isIgnoreParentName() {
        return this.ignoreParentName;
    }

    public boolean isIgnoreParentRemark() {
        return this.ignoreParentRemark;
    }

    public void setRef(List<DifferentField> ref) {
        this.ref = ref;
    }

    public void setIgnoreParentName(boolean ignoreParentName) {
        this.ignoreParentName = ignoreParentName;
    }

    public void setIgnoreParentRemark(boolean ignoreParentRemark) {
        this.ignoreParentRemark = ignoreParentRemark;
    }

    @Override
    public String toString() {
        return "DifferentRefField(ref=" + this.getRef() + ", ignoreParentName=" + this.isIgnoreParentName() + ", ignoreParentRemark=" + this.isIgnoreParentRemark() + ")";
    }

    public DifferentRefField() {
    }
}

