/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.json;

import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.number.NumberUtil;
import cloud.agileframework.common.util.string.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSONUtil
extends JSON {
    public static JSON toJSON(Object javaObject) {
        if (javaObject == null) {
            return null;
        }
        return (JSON)JSON.toJSON((Object)javaObject);
    }

    public static Object toMapOrList(Object json) {
        if (json == null) {
            return null;
        }
        if (!(json instanceof JSON)) {
            json = JSONUtil.toJSON(json);
        }
        if (JSONObject.class.isAssignableFrom(json.getClass())) {
            return JSONUtil.jsonObjectCoverMap((JSONObject)json);
        }
        if (JSONArray.class.isAssignableFrom(json.getClass())) {
            return JSONUtil.jsonArrayCoverArray((JSONArray)json);
        }
        return json.toString();
    }

    public static Map<String, Object> jsonObjectCoverMap(JSONObject json) {
        if (json == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(json.size());
        Set keySet = json.keySet();
        for (String key : keySet) {
            Object o = json.get((Object)key);
            if (o != null && JSONObject.class.isAssignableFrom(o.getClass())) {
                result.put(key, JSONUtil.jsonObjectCoverMap((JSONObject)o));
                continue;
            }
            if (o != null && JSONArray.class.isAssignableFrom(o.getClass())) {
                result.put(key, JSONUtil.jsonArrayCoverArray((JSONArray)o));
                continue;
            }
            result.put(key, o);
        }
        return result;
    }

    public static List<Object> jsonArrayCoverArray(JSONArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object o : jsonArray) {
            if (o != null && JSON.class.isAssignableFrom(o.getClass())) {
                if (JSONObject.class.isAssignableFrom(o.getClass())) {
                    result.add(JSONUtil.jsonObjectCoverMap((JSONObject)o));
                    continue;
                }
                if (!JSONArray.class.isAssignableFrom(o.getClass())) continue;
                result.add(JSONUtil.jsonArrayCoverArray((JSONArray)o));
                continue;
            }
            if (o == null) continue;
            result.add(o);
        }
        return result;
    }

    public static Object pathGet(String key, Object o) {
        Object result;
        if (o == null) {
            return null;
        }
        if (key.contains(".")) {
            String parentKey = StringUtil.getSplitAtomic(key, "[.]", 0);
            Object parentValue = JSONUtil.getValue(parentKey, o);
            result = JSONUtil.pathGet(key.replaceFirst(parentKey + ".", ""), parentValue);
        } else {
            result = JSONUtil.getValue(key, o);
        }
        return result;
    }

    private static Object getValue(String key, Object o) {
        String all = "all";
        ArrayList result = null;
        if (Map.class.isAssignableFrom(o.getClass())) {
            result = (ArrayList)((Map)o).get(key);
        } else if (List.class.isAssignableFrom(o.getClass())) {
            if (NumberUtil.isCreatable((String)key) && ((List)o).size() > Integer.parseInt(key)) {
                result = (ArrayList)((List)o).get(Integer.parseInt(key));
            } else if ("all".equals(key)) {
                ArrayList cache = new ArrayList();
                for (Object node : (List)o) {
                    if (List.class.isAssignableFrom(node.getClass())) {
                        cache.addAll((List)node);
                        continue;
                    }
                    cache.add(node);
                }
                if (cache.size() > 0) {
                    result = cache;
                }
            } else if (key.contains(",")) {
                String[] indexes;
                ArrayList cache = new ArrayList();
                for (String index : indexes = key.split(",")) {
                    if (!NumberUtil.isCreatable((String)index)) continue;
                    int number = Integer.parseInt(index);
                    if (((List)o).size() <= number) continue;
                    cache.add(((List)o).get(number));
                }
                if (cache.size() > 0) {
                    result = cache;
                }
            } else {
                ArrayList<Object> cache = new ArrayList<Object>();
                for (Object node : (List)o) {
                    Object cacheNode = JSONUtil.pathGet(key, node);
                    if (cacheNode == null) continue;
                    cache.add(cacheNode);
                }
                if (cache.size() > 0) {
                    result = cache;
                }
            }
        } else {
            try {
                Field field = ClassUtil.getField(o.getClass(), key);
                if (field != null) {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    result = field.get(o);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return result;
    }
}

