/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.ip;

import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.ip.IPv4Util;
import cloud.agileframework.common.util.object.ObjectUtil;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.commons.lang3.math.NumberUtils;

public class IPSerializer
implements ObjectSerializer,
ObjectDeserializer {
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        Long ipLong;
        if (object == null) {
            return;
        }
        if (object instanceof Number) {
            ipLong = (Long)ObjectUtil.to((Object)((Number)object).longValue(), new TypeReference(fieldType));
        } else if (NumberUtils.isCreatable((String)object.toString())) {
            ipLong = (Long)ObjectUtil.to(object, new TypeReference((Type)((Object)Long.class)));
        } else {
            serializer.write(object);
            return;
        }
        String ip = IPv4Util.longToIP(ipLong);
        serializer.write(ip);
    }

    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        Object value = parser.parse();
        if (value instanceof Number) {
            return ObjectUtil.to(value, new TypeReference(type));
        }
        if (NumberUtils.isCreatable((String)value.toString())) {
            return ObjectUtil.to(value, new TypeReference(type));
        }
        return ObjectUtil.to((Object)IPv4Util.ipToLong(value.toString()), new TypeReference(type));
    }

    public int getFastMatchToken() {
        return 0;
    }
}

