/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.http;

import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.http.NotFoundRequestMethodException;
import cloud.agileframework.common.util.http.Protocol;
import cloud.agileframework.common.util.http.RequestMethod;
import cloud.agileframework.common.util.map.MapUtil;
import cloud.agileframework.common.util.object.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtil.class);
    private static final String HTTPS_PREFIX = "https://";
    private static final String HTTP_PREFIX = "http://";
    private static final Map<String, InetAddress> MAPPING = Maps.newHashMap();

    public static String get(String url) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.GET, url, null, null);
    }

    public static String get(String url, Object header) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.GET, url, header, null);
    }

    public static String get(String url, Object header, Object param) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.GET, url, header, param);
    }

    public static String post(String url) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.POST, url, null, null);
    }

    public static String post(String url, Object param) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.POST, url, null, param);
    }

    public static String post(String url, Object header, Object param) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.POST, url, header, param);
    }

    public static String put(String url) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.PUT, url, null, null);
    }

    public static String put(String url, Object param) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.PUT, url, null, param);
    }

    public static String put(String url, Object header, Object param) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.PUT, url, header, param);
    }

    public static String delete(String url) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.DELETE, url, null, null);
    }

    public static String delete(String url, Object param) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.DELETE, url, null, param);
    }

    public static String delete(String url, Object header, Object param) {
        return HttpUtil.send(Protocol.extract(url), RequestMethod.DELETE, url, header, param);
    }

    public static CloseableHttpResponse originalSend(Protocol protocol, String var0, RequestMethod method, String url, Object header, Object param) {
        int max;
        URI uri = URI.create(url);
        for (int count = max = 10; count > 0; --count) {
            try {
                CloseableHttpClient httpClient = HttpUtil.getHttpClient(protocol, var0);
                HttpRequestBase httpRequestBase = HttpUtil.getHttpRequestBase(method);
                if (!MAPPING.isEmpty()) {
                    httpRequestBase.setConfig(RequestConfig.custom().setLocalAddress(MAPPING.get(uri.getHost())).build());
                }
                HttpUtil.parseHeader(header, httpRequestBase);
                url = HttpUtil.parseParam(url, param, httpRequestBase);
                url = HttpUtil.parseUrl(protocol, url);
                httpRequestBase.setURI(uri);
                return httpClient.execute((HttpUriRequest)httpRequestBase);
            }
            catch (NotFoundRequestMethodException e) {
                logger.error("\u7b2c\u4e8c\u4e2a\u53c2\u6570 method \u672a\u6210\u529f\u5206\u6790\u51fa\u8bf7\u6c42\u65b9\u5f0f", (Throwable)e);
                return null;
            }
            catch (ConnectException e) {
                List<InetAddress> localIpAddress = HttpUtil.getLocalIpAddress();
                int index = max - count;
                if (index > localIpAddress.size() - 1) {
                    logger.error("\u7f51\u7edc\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
                    return null;
                }
                MAPPING.put(uri.getHost(), localIpAddress.get(index));
                continue;
            }
            catch (Exception e) {
                logger.error("\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static List<InetAddress> getLocalIpAddress() {
        Enumeration<NetworkInterface> interfaces;
        ArrayList<InetAddress> ipList = new ArrayList<InetAddress>();
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return ipList;
        }
        while (interfaces.hasMoreElements()) {
            NetworkInterface ni = interfaces.nextElement();
            Enumeration<InetAddress> ipAddressEnum = ni.getInetAddresses();
            while (ipAddressEnum.hasMoreElements()) {
                InetAddress address = ipAddressEnum.nextElement();
                if (address.isLoopbackAddress() || address.isLinkLocalAddress()) continue;
                ipList.add(address);
            }
        }
        return ipList;
    }

    public static String send(Protocol protocol, RequestMethod method, String url, Object header, Object param) {
        return HttpUtil.send(protocol, "SSL", method, url, header, param);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String send(Protocol protocol, String var0, RequestMethod method, String url, Object header, Object param) {
        try (CloseableHttpResponse response = HttpUtil.originalSend(protocol, var0, method, url, header, param);){
            String string = HttpUtil.toStringContent((HttpResponse)response);
            return string;
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private static String parseParam(String url, Object param, HttpRequestBase httpRequestBase) {
        if (param != null && httpRequestBase instanceof HttpEntityEnclosingRequestBase) {
            Header contentEncoding;
            Header connection;
            String content = param instanceof String ? (String)param : JSON.toJSONString((Object)param);
            Header contentType = httpRequestBase.getLastHeader("Content-Type");
            if (contentType == null) {
                contentType = new BasicHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
                httpRequestBase.setHeader(contentType);
            }
            if ((connection = httpRequestBase.getLastHeader("Connection")) == null) {
                connection = new BasicHeader("Connection", "Close");
                httpRequestBase.setHeader(connection);
            }
            if ((contentEncoding = httpRequestBase.getLastHeader("Content-Encoding")) == null) {
                contentEncoding = new BasicHeader("Content-Encoding", ContentType.APPLICATION_JSON.getCharset().name());
                httpRequestBase.setHeader(contentEncoding);
            }
            StringEntity entity = new StringEntity(content, ContentType.parse((String)contentType.getValue()));
            entity.setContentType(contentType);
            entity.setContentEncoding(contentEncoding);
            ((HttpEntityEnclosingRequestBase)httpRequestBase).setEntity((HttpEntity)entity);
        } else if (param != null) {
            Map<String, Object> paramMap = ObjectUtil.to(param, new TypeReference<Map<String, Object>>(){});
            String paramUrl = MapUtil.toUrl(paramMap);
            url = url.contains("?") ? url + paramUrl : url + "?" + paramUrl;
        }
        return url;
    }

    private static void parseHeader(Object header, HttpRequestBase httpRequestBase) {
        if (header instanceof Header) {
            httpRequestBase.setHeader((Header)header);
        } else if (header != null) {
            Map<String, Object> map = ObjectUtil.to(header, new TypeReference<Map<String, Object>>(){});
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                httpRequestBase.setHeader(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
    }

    private static HttpRequestBase getHttpRequestBase(RequestMethod method) throws NotFoundRequestMethodException {
        HttpGet httpRequestBase;
        switch (method) {
            case GET: {
                httpRequestBase = new HttpGet();
                break;
            }
            case PUT: {
                httpRequestBase = new HttpPut();
                break;
            }
            case POST: {
                httpRequestBase = new HttpPost();
                break;
            }
            case DELETE: {
                httpRequestBase = new HttpDelete();
                break;
            }
            default: {
                throw new NotFoundRequestMethodException();
            }
        }
        return httpRequestBase;
    }

    private static String parseUrl(Protocol protocol, String url) {
        url = url.trim();
        String lowerCase = url.toLowerCase();
        if (Protocol.Https == protocol && !lowerCase.startsWith(HTTPS_PREFIX)) {
            url = HTTPS_PREFIX + url;
        } else if (Protocol.Http == protocol && !lowerCase.startsWith(HTTP_PREFIX)) {
            url = HTTP_PREFIX + url;
        }
        return url;
    }

    private static CloseableHttpClient getHttpClient(Protocol protocol, String var0) throws KeyManagementException, NoSuchAlgorithmException {
        CloseableHttpClient httpClient = protocol == Protocol.Https ? HttpUtil.getHttpsClient(var0) : HttpClients.createDefault();
        return httpClient;
    }

    public static CloseableHttpClient getHttpsClient(String var0) throws KeyManagementException, NoSuchAlgorithmException {
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(HttpUtil.createIgnoreVerifySSL(var0), (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
    }

    public static SSLContext createIgnoreVerifySSL(String var0) throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslContext = SSLContext.getInstance(var0);
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        sslContext.init(null, new TrustManager[]{trustManager}, null);
        return sslContext;
    }

    private static String toStringContent(HttpResponse response) {
        if (response == null) {
            return null;
        }
        String temp = null;
        try {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                temp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
        }
        catch (IOException e) {
            logger.error("\u54cd\u5e94\u6d41\u8bfb\u53d6\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (response instanceof CloseableHttpResponse) {
                try {
                    ((CloseableHttpResponse)response).close();
                }
                catch (IOException e) {
                    logger.error("\u54cd\u5e94\u6d41\u8bfb\u53d6\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return temp;
    }

    public static boolean isIPv4(String str) {
        String ipRegex = "[0-9]*[.][0-9]*[.][0-9]*[.][0-9]*";
        if (!Pattern.matches("[0-9]*[.][0-9]*[.][0-9]*[.][0-9]*", str)) {
            return false;
        }
        String[] arrays = str.split("\\.");
        return Integer.parseInt(arrays[0]) < 256 && arrays[0].length() <= 3 && Integer.parseInt(arrays[1]) < 256 && arrays[0].length() <= 3 && Integer.parseInt(arrays[2]) < 256 && arrays[0].length() <= 3 && Integer.parseInt(arrays[3]) < 256 && arrays[0].length() <= 3;
    }

    public static boolean isIPv6(String str) {
        return Pattern.matches("[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][:][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][:][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][:][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][:][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][:][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][:][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][:][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]", str);
    }
}

