/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.file;

import cloud.agileframework.common.util.stream.ThrowingConsumer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class FileUtil {
    public static void downloadFile(String fileName, ThrowingConsumer<HttpServletResponse> write, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String characterEncoding = request.getCharacterEncoding();
        if (characterEncoding != null) {
            response.setCharacterEncoding(characterEncoding);
        }
        response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(fileName, characterEncoding) + "; filename*=" + characterEncoding + "''" + URLEncoder.encode(fileName, characterEncoding) + ";");
        write.accept(response);
    }

    public static void downloadFile(String fileName, File file, HttpServletRequest request, HttpServletResponse response) throws IOException {
        fileName = fileName == null ? file.getName() : fileName;
        FileUtil.downloadFile(fileName, (HttpServletResponse response1) -> IOUtils.copy((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0]), (OutputStream)response1.getOutputStream()), request, response);
    }

    public static void downloadFile(File file, HttpServletRequest request, HttpServletResponse response) throws IOException {
        FileUtil.downloadFile(file.getName(), file, request, response);
    }

    public static File createZip(String dir, String zipFileName, File ... files) throws IOException {
        if (!zipFileName.toLowerCase().endsWith(".zip")) {
            zipFileName = zipFileName + ".zip";
        }
        File zip = FileUtil.createFile(dir, zipFileName);
        FileUtil.addFileToZip(zip, files);
        return zip;
    }

    public static File createFile(String path, String fileName) throws IOException {
        File dir = new File(path);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("create dir " + path + " fail");
        }
        File file = new File(dir.getPath() + File.separator + fileName);
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("create file " + path + fileName + " fail");
        }
        return file;
    }

    public static void addFileToZip(File zipFile, String ... filepath) throws IOException {
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(zipFile.toPath(), new OpenOption[0]));){
            for (String path : filepath) {
                URL url = new URL(path);
                URLConnection connection = url.openConnection();
                InputStream fileInputStream = connection.getInputStream();
                String fileName = File.separatorChar + path.substring(path.lastIndexOf(File.separatorChar) + 1);
                out.putNextEntry(new ZipEntry(fileName));
                IOUtils.copy((InputStream)fileInputStream, (OutputStream)out);
            }
            out.flush();
        }
    }

    public static void addFileToZip(File zipFile, File ... files) throws IOException {
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(zipFile.toPath(), new OpenOption[0]));){
            for (File fileObject : files) {
                out.putNextEntry(new ZipEntry(fileObject.getName()));
                try (InputStream inputStream = Files.newInputStream(fileObject.toPath(), new OpenOption[0]);){
                    IOUtils.copy((InputStream)inputStream, (OutputStream)out);
                }
            }
            out.flush();
        }
    }

    public static boolean isIllegalDirName(String dirName) {
        return dirName.matches("(.*)([\\\\/.~:*?\"<>|])(.*)");
    }

    public static String parseFilePath(String str) {
        String url = str.replaceAll("[\\\\/]+", Matcher.quoteReplacement(File.separator));
        if (!url.endsWith(File.separator)) {
            url = url + File.separator;
        }
        return url;
    }

    public static String parseClassPath(String str) {
        String prefix = "/";
        String url = str.replaceAll("[\\\\/]+", prefix);
        if (!url.startsWith(prefix)) {
            url = prefix + url;
        }
        return url;
    }
}

