/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.collection;

import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.collection.ParentWrapper;
import cloud.agileframework.common.util.collection.TreeBase;
import cloud.agileframework.common.util.object.ObjectUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TreeUtil {
    public static <A extends Serializable, T extends TreeBase<A, T>> SortedSet<T> createTree(Collection<? extends T> nodes, A rootValue, String splitChar, Set<Field> fullFieldSet) {
        Map<Optional, List<TreeBase>> children = nodes.stream().filter(node -> {
            node.getChildren().clear();
            return !Objects.equals(node.getParentId(), rootValue);
        }).collect(Collectors.groupingBy(n -> Optional.ofNullable(n.getParentId())));
        nodes.forEach(node -> {
            List child = (List)children.get(Optional.ofNullable(node.getId()));
            if (child == null) {
                return;
            }
            node.setChildren(new ConcurrentSkipListSet(child));
        });
        if (fullFieldSet != null && !fullFieldSet.isEmpty()) {
            List<ParentWrapper> wrapperList = nodes.stream().map(ParentWrapper::new).collect(Collectors.toList());
            ConcurrentMap map = Maps.newConcurrentMap();
            wrapperList.forEach(a -> map.put(a.getCurrent().getId(), a));
            wrapperList.forEach(a -> {
                Object parentId = a.getCurrent().getParentId();
                if (parentId == null) {
                    return;
                }
                ParentWrapper parentWrapper = (ParentWrapper)map.get(parentId);
                if (parentWrapper == null) {
                    return;
                }
                a.setParent(parentWrapper);
            });
            ConcurrentMap cache = Maps.newConcurrentMap();
            fullFieldSet.forEach(b -> {
                wrapperList.forEach(a -> {
                    Object v = a.getFull((Field)b, splitChar);
                    if (v == null) {
                        return;
                    }
                    cache.put(v, a.getCurrent());
                });
                cache.entrySet().forEach(e -> ObjectUtil.setValue(e.getValue(), b, e.getKey()));
                cache.clear();
            });
        }
        return nodes.stream().filter(node -> Objects.equals(node.getParentId(), rootValue)).collect(Collectors.toCollection(ConcurrentSkipListSet::new));
    }

    public static <A extends Serializable, T extends TreeBase<A, T>> SortedSet<T> createTree(Collection<? extends T> list, A rootValue, String splitChar, String ... fullFields) {
        if (!list.isEmpty()) {
            TreeBase entity = (TreeBase)list.stream().findAny().get();
            Class<?> tClass = entity.getClass();
            Set<Field> fullFieldSet = Stream.of(fullFields).map(fieldName -> ClassUtil.getField(tClass, fieldName)).filter(Objects::nonNull).collect(Collectors.toSet());
            return TreeUtil.createTree(list, rootValue, splitChar, fullFieldSet);
        }
        return new ConcurrentSkipListSet();
    }

    public static <A extends Serializable, T extends TreeBase<A, T>> SortedSet<T> createTree(Collection<? extends T> list, A rootValue) {
        return TreeUtil.createTree(list, rootValue, ".", new String[0]);
    }

    public static <A extends Serializable, T extends TreeBase<A, T>> SortedSet<T> createTreeByNodeIds(Collection<? extends T> all, Collection<A> ids, A rootValue) {
        return TreeUtil.createTreeByNodeIds(all, ids, rootValue, "$$", new String[0]);
    }

    public static <A extends Serializable, T extends TreeBase<A, T>> SortedSet<T> createTreeByNodeIds(Collection<? extends T> all, Collection<A> ids, A rootValue, String splitChar, String ... fullFields) {
        if (CollectionUtils.isEmpty(ids)) {
            all.clear();
            return Sets.newTreeSet();
        }
        List allWrapper = all.stream().map(TreeBaseProxy::new).collect(Collectors.toList());
        TreeUtil.createTree(allWrapper, rootValue, splitChar, "fullId");
        Set relevantNode = allWrapper.stream().filter(m -> ids.contains(m.getId())).flatMap(m -> Arrays.stream(StringUtils.split((String)m.getFullId(), (String)splitChar))).collect(Collectors.toSet());
        allWrapper.removeIf(m -> !relevantNode.contains(String.valueOf(m.getId())));
        List allNodes = allWrapper.stream().map(TreeBaseProxy::getTreeBase).map(a -> a).collect(Collectors.toList());
        return TreeUtil.createTree(allNodes, rootValue, splitChar, fullFields);
    }

    public static class TreeBaseProxy<A extends Serializable, T extends TreeBase<A, T>>
    extends TreeBase<A, TreeBaseProxy<A, T>> {
        private final T treeBase;
        private String fullId;

        public TreeBaseProxy(T treeBase) {
            this.treeBase = treeBase;
            this.fullId = String.valueOf(this.getId());
        }

        @Override
        public A getId() {
            return (A)((TreeBase)this.treeBase).getId();
        }

        @Override
        public A getParentId() {
            return (A)((TreeBase)this.treeBase).getParentId();
        }

        @Override
        public Integer getSort() {
            return ((TreeBase)this.treeBase).getSort();
        }

        public String getFullId() {
            return this.fullId;
        }

        public void setFullId(String fullId) {
            this.fullId = fullId;
        }

        public TreeBase<A, T> getTreeBase() {
            return this.treeBase;
        }
    }
}

