/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.collection;

import cloud.agileframework.common.util.collection.SortInfo;
import cloud.agileframework.common.util.number.NumberUtil;
import cloud.agileframework.common.util.object.ObjectUtil;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;

public class CollectionsUtil {
    private CollectionsUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static <T> void sort(List<T> list, String property) {
        CollectionsUtil.sort(list, SortInfo.builder().property(property).sort(true).build());
    }

    public static <T> void sort(List<T> list, SortInfo ... sortInfos) {
        if (sortInfos == null || sortInfos.length == 0) {
            return;
        }
        list.sort((o1, o2) -> {
            int v = 0;
            try {
                SortInfo sort;
                String property;
                SortInfo[] sortInfoArray = sortInfos;
                int n = sortInfoArray.length;
                for (int i = 0; i < n && (v = CollectionsUtil.compare(o1, o2, property = (sort = sortInfoArray[i]).getProperty(), sort.isSort())) == 0; ++i) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return v;
        });
    }

    private static <T> int compare(T o1, T o2, String property, boolean sort) {
        Object o1Value = CollectionsUtil.getValue(o1, property);
        Object o2Value = CollectionsUtil.getValue(o2, property);
        int result = CollectionsUtil.compare(o1Value, o2Value);
        return sort ? result : -result;
    }

    private static Object getValue(Object o1, String property) {
        if (o1 == null) {
            return null;
        }
        if (Map.class.isAssignableFrom(o1.getClass())) {
            return ((Map)o1).get(property);
        }
        return ObjectUtil.getFieldValue(o1, property);
    }

    private static int compare(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 == o2) {
            return 0;
        }
        if (NumberUtil.isNumber(o1.getClass()) && NumberUtil.isNumber(o2.getClass())) {
            return NumberUtils.createDouble((String)o1.toString()).compareTo(NumberUtils.createDouble((String)o2.toString()));
        }
        return o1.toString().compareTo(o2.toString());
    }
}

