/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.clazz;

import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.clazz.TypeEnum;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public class TypeReference<T> {
    private Type type;

    public TypeReference() {
        Type genType = this.getClass().getGenericSuperclass();
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        this.type = params[0];
    }

    public TypeReference(Type type) {
        this.type = type;
    }

    public TypeEnum toEnum() {
        if (this.type instanceof TypeVariable) {
            return TypeEnum.TypeVariable;
        }
        if (this.type instanceof ParameterizedType) {
            return TypeEnum.ParameterizedType;
        }
        if (this.type instanceof GenericArrayType) {
            return TypeEnum.GenericArrayType;
        }
        if (this.type instanceof WildcardType) {
            return TypeEnum.WildcardType;
        }
        return TypeEnum.Class;
    }

    public void replace(Type type) {
        this.type = type;
    }

    public boolean isAssignableFrom(Class<?> clazz) {
        return ClassUtil.isAssignableFrom(this.type, clazz, true);
    }

    public boolean isExtendsFrom(Class<?> clazz) {
        return ClassUtil.isAssignableFrom(this.type, clazz, false);
    }

    public Class<Enum> extractEnum() {
        if (this.type instanceof Class && ((Class)this.type).isEnum()) {
            return (Class)this.type;
        }
        return null;
    }

    public boolean isEnum() {
        Class<Enum> enumClass = this.extractEnum();
        return enumClass != null;
    }

    public static Class<?> extractArray(Type type) {
        if (type instanceof ParameterizedType) {
            return null;
        }
        if (type instanceof GenericArrayType) {
            return TypeReference.extractArray(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof TypeVariable) {
            return null;
        }
        if (type instanceof WildcardType) {
            return null;
        }
        return ((Class)type).getComponentType();
    }

    public Class<?> extractArray() {
        return TypeReference.extractArray(this.type);
    }

    public boolean isArray() {
        Class<?> t = TypeReference.extractArray(this.type);
        return t != null;
    }

    public boolean isWrapOrPrimitive() {
        Class<?> c = ClassUtil.isWrapOrPrimitive(this.type);
        return c != null;
    }

    public Class<?> extractWrapOrPrimitive() {
        return ClassUtil.isWrapOrPrimitive(this.type);
    }

    public Type getType() {
        return this.type;
    }

    public Constructor<T> getConstruct(Class<?> ... parameterTypes) {
        return ClassUtil.getConstruct(this.type, parameterTypes);
    }
}

