/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.clazz;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FieldInfo {
    private Map<Method, Integer> setters;
    private Boolean noSetters;
    private Map<Method, Integer> getters;
    private Boolean noGetters;

    public void putSetter(Method setter) {
        Integer order;
        if (this.setters == null) {
            this.setters = Maps.newConcurrentMap();
        }
        if ((order = this.setters.get(setter)) == null) {
            this.setters.put(setter, 0);
        } else {
            order = order + 1;
            this.setters.put(setter, order);
        }
    }

    public void putGetter(Method getter) {
        Integer order;
        if (this.getters == null) {
            this.getters = Maps.newConcurrentMap();
        }
        if ((order = this.getters.get(getter)) == null) {
            this.getters.put(getter, 0);
        } else {
            order = order + 1;
            this.getters.put(getter, order);
        }
    }

    public List<Method> getters() {
        if (this.getters != null) {
            return this.getters.entrySet().stream().sorted((a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
        }
        return Lists.newArrayListWithExpectedSize((int)0);
    }

    public List<Method> setters() {
        if (this.setters != null) {
            return this.setters.entrySet().stream().sorted((a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
        }
        return Lists.newArrayListWithExpectedSize((int)0);
    }

    public Boolean isNoSetters() {
        return this.noSetters;
    }

    public void setNoSetters(boolean noSetters) {
        this.noSetters = noSetters;
    }

    public Boolean isNoGetters() {
        return this.noGetters;
    }

    public void setNoGetters(boolean noGetters) {
        this.noGetters = noGetters;
    }
}

