/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.clazz;

import cloud.agileframework.common.util.clazz.ClassInfo;
import cloud.agileframework.common.util.string.StringUtil;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.ClassUtils;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class ClassUtil
extends ClassUtils {
    public static Set<Field> getAllField(Class<?> clazz) {
        ClassInfo<Class<?>> classInfo = ClassInfo.getCache(clazz);
        return classInfo.getAllField();
    }

    public static Set<Method> getAllMethod(Class<?> clazz) {
        ClassInfo<Class<?>> classInfo = ClassInfo.getCache(clazz);
        return classInfo.getAllMethod();
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        ClassInfo<Class<?>> classInfo = ClassInfo.getCache(clazz);
        if (paramTypes == null) {
            return classInfo.getMethod(methodName, new Class[0]);
        }
        return classInfo.getMethod(methodName, paramTypes);
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        ClassInfo<Class<?>> classInfo = ClassInfo.getCache(clazz);
        return classInfo.getField(fieldName);
    }

    public static boolean isWrapOrPrimitive(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        try {
            return ((Class)clazz.getDeclaredField("TYPE").get(null)).isPrimitive();
        }
        catch (IllegalAccessException | NoSuchFieldException ignored) {
            return false;
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        ClassInfo<Class<T>> classInfo = ClassInfo.getCache(clazz);
        return classInfo.getConstructor(parameterTypes);
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            ClassInfo<Class<T>> classInfo = ClassInfo.getCache(clazz);
            Constructor privateConstructor = classInfo.getPrivateConstructor();
            if (privateConstructor == null) {
                try {
                    Constructor[] constructors;
                    Method method = Class.class.getDeclaredMethod("privateGetDeclaredConstructors", Boolean.TYPE);
                    method.setAccessible(true);
                    for (Constructor constructor : constructors = (Constructor[])method.invoke(clazz, false)) {
                        constructor.setAccessible(true);
                        if (constructor.getParameterCount() != 0) continue;
                        privateConstructor = constructor;
                        classInfo.setPrivateConstructor(privateConstructor);
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException method) {
                    // empty catch block
                }
            }
            if (privateConstructor != null) {
                try {
                    return (T)privateConstructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    return null;
                }
            }
            return null;
        }
    }

    public static boolean isAssignableFrom(Class<?> clazz, Class<?> other) {
        return clazz.isAssignableFrom(other);
    }

    public static boolean isExtendsFrom(Class<?> clazz, Class<?> other) {
        return other.isAssignableFrom(clazz);
    }

    public static boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive();
    }

    public static <A extends Annotation> A getFieldAnnotation(Class<?> clazz, String fieldName, Class<A> annotationClass) {
        A result = null;
        Field field = ClassUtil.getField(clazz, fieldName);
        if (field == null) {
            return result;
        }
        result = field.getAnnotation(annotationClass);
        if (result != null) {
            return result;
        }
        Method getMethod = ClassUtil.getMethod(clazz, "get" + StringUtil.toUpperName(fieldName), new Class[0]);
        if (getMethod == null && field.getType() == Boolean.TYPE) {
            getMethod = ClassUtil.getMethod(clazz, "is" + StringUtil.toUpperName(fieldName), new Class[0]);
        }
        if (getMethod != null) {
            result = getMethod.getAnnotation(annotationClass);
        }
        return result;
    }

    public static <A extends Annotation> Set<Target<A>> getAllFieldAnnotation(Class<?> clazz, Class<A> annotationClass) {
        ClassInfo<Class<?>> classInfo = ClassInfo.getCache(clazz);
        return classInfo.getAllFieldAnnotation(annotationClass);
    }

    public static <A extends Annotation> Set<Target<A>> getAllMethodAnnotation(Class<?> clazz, Class<A> annotationClass) {
        ClassInfo<Class<?>> classInfo = ClassInfo.getCache(clazz);
        return classInfo.getAllMethodAnnotation(annotationClass);
    }

    public static <A extends Annotation> Set<Target<A>> getAllEntityAnnotation(Class<?> clazz, Class<A> annotation) {
        Set<Target<A>> fieldAnnotation = ClassUtil.getAllFieldAnnotation(clazz, annotation);
        Set<Target<A>> methodAnnotation = ClassUtil.getAllMethodAnnotation(clazz, annotation);
        for (Target<A> target : methodAnnotation) {
            String name = target.getMember().getName();
            if (!name.startsWith("get")) continue;
            int length = 3;
            Field targetField = ClassUtil.getField(clazz, StringUtil.toLowerName(name.substring(3)));
            fieldAnnotation.add(new Target<A>(targetField, target.getAnnotation()));
        }
        return fieldAnnotation;
    }

    public static Constructor<Type> getConstruct(Type type, Class<?> ... parameterTypes) {
        if (type instanceof ParameterizedType) {
            return ClassUtil.getConstruct((ParameterizedType)type, parameterTypes);
        }
        if (type instanceof GenericArrayType) {
            return null;
        }
        if (type instanceof TypeVariable) {
            return ClassUtil.getConstruct((TypeVariable)type, parameterTypes);
        }
        if (type instanceof WildcardType) {
            return ClassUtil.getConstruct((WildcardType)type, parameterTypes);
        }
        return ClassUtil.getConstruct((Class)type, parameterTypes);
    }

    public static Constructor<Type> getConstruct(ParameterizedType parameterizedType, Class<?>[] parameterTypes) {
        return ClassUtil.getConstruct(parameterizedType.getRawType(), parameterTypes);
    }

    public static Constructor<Type> getConstruct(TypeVariable<?> typeVariable, Class<?>[] parameterTypes) {
        for (Type a : typeVariable.getBounds()) {
            Constructor<Type> construct = ClassUtil.getConstruct(a, parameterTypes);
            if (construct == null) continue;
            return construct;
        }
        return null;
    }

    public static Constructor<Type> getConstruct(WildcardType wildcardType, Class<?>[] parameterTypes) {
        for (Type a : wildcardType.getLowerBounds()) {
            Constructor<Type> construct = ClassUtil.getConstruct(a, parameterTypes);
            if (construct == null) continue;
            return construct;
        }
        return null;
    }

    public static <F> Constructor<F> getConstruct(Class<F> clazz, Class<?>[] parameterTypes) {
        if (clazz.isInterface()) {
            return null;
        }
        return ClassUtil.getConstructor(clazz, parameterTypes);
    }

    public static Class<?> isWrapOrPrimitive(Type type) {
        if (type instanceof ParameterizedType) {
            return null;
        }
        if (type instanceof GenericArrayType) {
            return null;
        }
        if (type instanceof TypeVariable) {
            return ClassUtil.isWrapOrPrimitive((TypeVariable)type);
        }
        if (type instanceof WildcardType) {
            return ClassUtil.isWrapOrPrimitive((WildcardType)type);
        }
        if (ClassUtils.isPrimitiveOrWrapper((Class)((Class)type))) {
            return (Class)type;
        }
        return null;
    }

    public static Class<?> isWrapOrPrimitive(TypeVariable<?> type) {
        for (Type type1 : type.getBounds()) {
            Class<?> wrapOrPrimitive = ClassUtil.isWrapOrPrimitive(type1);
            if (wrapOrPrimitive == null) continue;
            return wrapOrPrimitive;
        }
        return null;
    }

    public static Class<?> isWrapOrPrimitive(WildcardType type) {
        for (Type type1 : type.getUpperBounds()) {
            Class<?> wrapOrPrimitive = ClassUtil.isWrapOrPrimitive(type1);
            if (wrapOrPrimitive == null) continue;
            return wrapOrPrimitive;
        }
        return null;
    }

    public static boolean isAssignableFrom(Type type, Class<?> clazz, boolean positive) {
        if (type instanceof ParameterizedType) {
            return ClassUtil.isAssignableFrom((ParameterizedType)type, clazz, positive);
        }
        if (type instanceof GenericArrayType) {
            return ClassUtil.isAssignableFrom((GenericArrayType)type, clazz, positive);
        }
        if (type instanceof TypeVariable) {
            return ClassUtil.isAssignableFrom((TypeVariable)type, clazz, positive);
        }
        if (type instanceof WildcardType) {
            return ClassUtil.isAssignableFrom((WildcardType)type, clazz, positive);
        }
        return ClassUtil.isAssignableFrom((Class)type, clazz, positive);
    }

    public static boolean isAssignableFrom(Class<?> type, Type clazz, boolean positive) {
        if (clazz instanceof ParameterizedType) {
            return ClassUtil.isAssignableFrom((ParameterizedType)clazz, type, positive);
        }
        if (clazz instanceof GenericArrayType) {
            return ClassUtil.isAssignableFrom((GenericArrayType)clazz, type, positive);
        }
        if (clazz instanceof TypeVariable) {
            return ClassUtil.isAssignableFrom((TypeVariable)clazz, type, positive);
        }
        if (clazz instanceof WildcardType) {
            return ClassUtil.isAssignableFrom((WildcardType)clazz, type, positive);
        }
        return positive ? type.isAssignableFrom((Class)clazz) : ((Class)clazz).isAssignableFrom(type);
    }

    public static boolean isAssignableFrom(ParameterizedType parameterizedType, Class<?> clazz, boolean positive) {
        Type rawType = parameterizedType.getRawType();
        if (rawType instanceof Class) {
            return positive ? ((Class)rawType).isAssignableFrom(clazz) : clazz.isAssignableFrom((Class)rawType);
        }
        return ClassUtil.isAssignableFrom(rawType, clazz, positive);
    }

    public static boolean isAssignableFrom(GenericArrayType genericArrayType, Class<?> clazz, boolean positive) {
        Type genericComponentType = genericArrayType.getGenericComponentType();
        if (genericComponentType instanceof ParameterizedType) {
            return ClassUtil.isAssignableFrom((ParameterizedType)genericComponentType, clazz, positive);
        }
        if (genericComponentType instanceof TypeVariable) {
            return ClassUtil.isAssignableFrom((TypeVariable)genericComponentType, clazz, positive);
        }
        return false;
    }

    public static boolean isAssignableFrom(TypeVariable<?> typeVariable, Class<?> clazz, boolean positive) {
        Type[] bounds;
        if (positive) {
            return false;
        }
        for (Type type : bounds = typeVariable.getBounds()) {
            boolean is = ClassUtil.isAssignableFrom(type, clazz, false);
            if (!is) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(WildcardType wildcardType, Class<?> clazz, boolean positive) {
        Type[] lowerBounds = wildcardType.getLowerBounds();
        Type[] upperBounds = wildcardType.getUpperBounds();
        if (positive && lowerBounds.length > 0) {
            for (Type type : lowerBounds) {
                boolean is;
                if (!(type instanceof Class) || !(is = ClassUtil.isAssignableFrom(type, clazz, true))) continue;
                return true;
            }
        } else if (!positive && upperBounds.length > 0) {
            for (Type type : upperBounds) {
                boolean is = ClassUtil.isAssignableFrom(type, clazz, false);
                if (!is) continue;
                return true;
            }
        } else {
            return positive && upperBounds.length == 0;
        }
        return false;
    }

    public static Class<?> getWrapper(Type type) {
        if (type instanceof ParameterizedType) {
            return ClassUtil.getWrapper((ParameterizedType)type);
        }
        if (type instanceof TypeVariable) {
            return ClassUtil.getWrapper((TypeVariable)type);
        }
        if (type instanceof GenericArrayType) {
            return ClassUtil.getWrapper((GenericArrayType)type);
        }
        if (type instanceof WildcardType) {
            return ClassUtil.getWrapper((WildcardType)type);
        }
        return (Class)type;
    }

    public static Class<?> getWrapper(ParameterizedType type) {
        return ClassUtil.getWrapper(type.getRawType());
    }

    public static Class<?> getWrapper(TypeVariable<?> type) {
        boolean seen = false;
        Class<?> best = null;
        for (Type type1 : type.getBounds()) {
            Class<?> wrapper = ClassUtil.getWrapper(type1);
            if (wrapper == null || seen && (wrapper.isInterface() ? -1 : 1) >= 0) continue;
            seen = true;
            best = wrapper;
        }
        return seen ? best : null;
    }

    public static Class<?> getWrapper(GenericArrayType type) {
        Class<?> wrapper = ClassUtil.getWrapper(type.getGenericComponentType());
        if (wrapper == null) {
            return null;
        }
        return Array.newInstance(wrapper, 0).getClass();
    }

    public static Class<?> getWrapper(WildcardType type) {
        Class<?> result;
        boolean seen = false;
        Class<?> best = null;
        for (Type type1 : type.getUpperBounds()) {
            Class<?> wrapper = ClassUtil.getWrapper(type1);
            if (wrapper == null || seen && (wrapper.isInterface() ? -1 : 1) >= 0) continue;
            seen = true;
            best = wrapper;
        }
        Class<?> clazz = result = seen ? best : null;
        if (result == null) {
            boolean seen1 = false;
            Class<?> best1 = null;
            for (Type type1 : type.getLowerBounds()) {
                Class<?> wrapper = ClassUtil.getWrapper(type1);
                if (wrapper == null || seen1 && (wrapper.isInterface() ? -1 : 1) >= 0) continue;
                seen1 = true;
                best1 = wrapper;
            }
            result = seen1 ? best1 : null;
        }
        return result;
    }

    public static Type getGeneric(Class<?> clazz, Class<?> supperOrInterface, int post) {
        ConcurrentMap realTypeMapping = Maps.newConcurrentMap();
        ClassUtil.extractParameterizedTypeMap(clazz, realTypeMapping);
        return ClassUtil.getGeneric(clazz, supperOrInterface, post, realTypeMapping);
    }

    public static Type getGeneric(Type clazz, Class<?> parameterizedType, int post, Map<Type, Type> realTypeMapping) {
        if (parameterizedType.getTypeParameters().length == 0) {
            throw new IllegalArgumentException(parameterizedType + "\u4e0d\u662f\u53c2\u6570\u5316\u7c7b\u578b");
        }
        if (clazz instanceof Class) {
            Type temp;
            Type genericSuperclass = ((Class)clazz).getGenericSuperclass();
            if (genericSuperclass != null && genericSuperclass != Object.class && (temp = ClassUtil.getGeneric(genericSuperclass, parameterizedType, post, realTypeMapping)) != null) {
                return temp;
            }
            Type[] genericInterfaces = ((Class)clazz).getGenericInterfaces();
            if (genericInterfaces.length > 0) {
                for (Type genericInterface : genericInterfaces) {
                    Type temp2 = ClassUtil.getGeneric(genericInterface, parameterizedType, post, realTypeMapping);
                    if (temp2 == null) continue;
                    return temp2;
                }
            }
        }
        if (clazz instanceof ParameterizedType) {
            if (((ParameterizedType)clazz).getRawType() == parameterizedType) {
                Type type = ((ParameterizedType)clazz).getActualTypeArguments()[post];
                if (type instanceof Class) {
                    return type;
                }
                return realTypeMapping.get(type);
            }
            return ClassUtil.getGeneric(((ParameterizedType)clazz).getRawType(), parameterizedType, post, realTypeMapping);
        }
        return null;
    }

    private static void extractParameterizedTypeMap(Type type, Map<Type, Type> parameterizedTypeMap) {
        if (type instanceof Class) {
            ClassUtil.extractParameterizedTypeMap(((Class)type).getGenericSuperclass(), parameterizedTypeMap);
            for (Type genericInterface : ((Class)type).getGenericInterfaces()) {
                ClassUtil.extractParameterizedTypeMap(genericInterface, parameterizedTypeMap);
            }
            return;
        }
        if (type instanceof ParameterizedType) {
            Type[] realTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            TypeVariable<Class<T>>[] typeArguments = ((Class)((ParameterizedTypeImpl)type).getRawType()).getTypeParameters();
            for (int i = 0; i < realTypeArguments.length; ++i) {
                if (realTypeArguments[i] instanceof TypeVariable) {
                    parameterizedTypeMap.put(typeArguments[i], parameterizedTypeMap.get(realTypeArguments[i]));
                    continue;
                }
                parameterizedTypeMap.put(typeArguments[i], realTypeArguments[i]);
            }
            ClassUtil.extractParameterizedTypeMap(((ParameterizedTypeImpl)type).getRawType(), parameterizedTypeMap);
        }
    }

    public static class Target<A extends Annotation> {
        private Member member;
        private A annotation;

        public Member getMember() {
            return this.member;
        }

        public A getAnnotation() {
            return this.annotation;
        }

        public void setMember(Member member) {
            this.member = member;
        }

        public void setAnnotation(A annotation) {
            this.annotation = annotation;
        }

        public String toString() {
            return "ClassUtil.Target(member=" + this.getMember() + ", annotation=" + this.getAnnotation() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Target)) {
                return false;
            }
            Target other = (Target)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Member this$member = this.getMember();
            Member other$member = other.getMember();
            if (this$member == null ? other$member != null : !this$member.equals(other$member)) {
                return false;
            }
            A this$annotation = this.getAnnotation();
            A other$annotation = other.getAnnotation();
            return !(this$annotation == null ? other$annotation != null : !this$annotation.equals(other$annotation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Target;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Member $member = this.getMember();
            result = result * 59 + ($member == null ? 43 : $member.hashCode());
            A $annotation = this.getAnnotation();
            result = result * 59 + ($annotation == null ? 43 : $annotation.hashCode());
            return result;
        }

        public Target(Member member, A annotation) {
            this.member = member;
            this.annotation = annotation;
        }
    }
}

