/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.clazz;

import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.clazz.FieldInfo;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.common.util.pattern.PatternUtil;
import cloud.agileframework.common.util.string.StringUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.generics.repository.FieldRepository;
import sun.reflect.generics.repository.MethodRepository;

public class ClassInfo<T> {
    private static final Logger log = LoggerFactory.getLogger(ClassInfo.class);
    private static final Map<String, ClassInfo<?>> CACHE = Maps.newConcurrentMap();
    private final Class<T> clazz;
    private final Map<String, Type> typeVariableClassMap = Maps.newConcurrentMap();
    private Map<String, Constructor<T>> constructors;
    private Constructor<T> privateConstructor;
    private Set<Field> allField;
    private Set<Method> allMethod;
    private Map<String, Field> fieldMap;
    private Map<String, Method> methodMap;
    private Map<Class<? extends Annotation>, Set<ClassUtil.Target<?>>> fieldAnnotations;
    private Map<Class<? extends Annotation>, Set<ClassUtil.Target<?>>> methodAnnotations;
    private Map<Field, FieldInfo> fieldInfoCache;
    private boolean parsed = false;

    public ClassInfo(Type type) {
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            if (!(rawType instanceof Class)) {
                throw new IllegalArgumentException(type + "Unable to get complete class information");
            }
            this.clazz = (Class)rawType;
        } else if (type instanceof Class) {
            this.clazz = (Class)type;
        } else {
            throw new IllegalArgumentException(type + "Unable to get complete class information");
        }
        this.getTypeParameterName(type);
    }

    public static <A extends Type> ClassInfo<A> getCache(A type) {
        ClassInfo<Object> target = CACHE.get(type.toString());
        if (target == null) {
            target = new ClassInfo(type);
            CACHE.put(type.toString(), target);
        }
        return target;
    }

    private static void extractFieldRecursion(Class<?> clazz, Set<Field> set) {
        Field[] selfFields = clazz.getDeclaredFields();
        Field[] extendFields = clazz.getFields();
        set.addAll(Arrays.asList(selfFields));
        set.addAll(Arrays.asList(extendFields));
        Class<?> superClass = clazz.getSuperclass();
        if (superClass == Object.class || superClass == null) {
            return;
        }
        ClassInfo.extractFieldRecursion(superClass, set);
    }

    private static void extractMethodRecursion(Class<?> clazz, Set<Method> set) {
        Method[] selfMethods = clazz.getDeclaredMethods();
        Method[] extendMethods = clazz.getMethods();
        HashSet<Method> set1 = new HashSet<Method>();
        for (Method selfMethod : selfMethods) {
            if (selfMethod.getDeclaringClass() == Object.class) continue;
            set1.add(selfMethod);
        }
        set.addAll(set1);
        HashSet<Method> result = new HashSet<Method>();
        for (Method c : extendMethods) {
            if (c.getDeclaringClass() == Object.class) continue;
            result.add(c);
        }
        set.addAll(result);
        Class<?> superClass = clazz.getSuperclass();
        if (superClass == Object.class || superClass == null) {
            return;
        }
        ClassInfo.extractMethodRecursion(superClass, set);
    }

    private void getTypeParameterName(Type currentType) {
        if (currentType instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)currentType).getRawType();
            this.getTypeParameterName(rawType);
            return;
        }
        if (currentType == Object.class) {
            return;
        }
        if (currentType instanceof Class) {
            Type supper = ((Class)currentType).getGenericSuperclass();
            this.getTypeParameterName(supper);
            if (supper instanceof ParameterizedType) {
                Class superclass = ((Class)currentType).getSuperclass();
                TypeVariable<Class<T>>[] superClassTypeParameters = superclass.getTypeParameters();
                Type[] typeParameters = ((ParameterizedType)supper).getActualTypeArguments();
                for (int i = 0; i < superClassTypeParameters.length; ++i) {
                    TypeVariable key = superClassTypeParameters[i];
                    Type value = typeParameters[i];
                    if (value instanceof TypeVariable) {
                        value = this.typeVariableClassMap.get(((TypeVariable)value).getName());
                    }
                    if (value == null) continue;
                    this.typeVariableClassMap.put(key.getName(), value);
                }
            }
        }
    }

    public <A extends Annotation> Set<ClassUtil.Target<A>> getAllFieldAnnotation(Class<A> annotationClass) {
        Set set = null;
        if (this.fieldAnnotations != null) {
            set = this.fieldAnnotations.get(annotationClass);
        }
        if (set == null) {
            Set<Field> fields = this.getAllField();
            set = Sets.newConcurrentHashSet();
            for (Field field : fields) {
                A annotation = field.getAnnotation(annotationClass);
                if (annotation == null) continue;
                set.add(new ClassUtil.Target<A>(field, annotation));
            }
            if (this.fieldAnnotations == null) {
                this.fieldAnnotations = Maps.newConcurrentMap();
            }
            this.fieldAnnotations.put(annotationClass, set);
        }
        HashSet<ClassUtil.Target<A>> result = new HashSet<ClassUtil.Target<A>>();
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            ClassUtil.Target r;
            ClassUtil.Target aTarget = r = (ClassUtil.Target)iterator.next();
            result.add(aTarget);
        }
        return result;
    }

    public <A extends Annotation> Set<ClassUtil.Target<A>> getAllMethodAnnotation(Class<A> annotationClass) {
        Set set = null;
        if (this.methodAnnotations != null) {
            set = this.methodAnnotations.get(annotationClass);
        }
        if (set == null) {
            Set<Method> methods = this.getAllMethod();
            set = Sets.newConcurrentHashSet();
            for (Method method : methods) {
                A annotation = method.getAnnotation(annotationClass);
                if (annotation == null) continue;
                set.add(new ClassUtil.Target<A>(method, annotation));
            }
            if (this.methodAnnotations == null) {
                this.methodAnnotations = Maps.newConcurrentMap();
            }
            this.methodAnnotations.put(annotationClass, set);
        }
        HashSet<ClassUtil.Target<A>> result = new HashSet<ClassUtil.Target<A>>();
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            ClassUtil.Target r;
            ClassUtil.Target aTarget = r = (ClassUtil.Target)iterator.next();
            result.add(aTarget);
        }
        return result;
    }

    public Constructor<T> getPrivateConstructor() {
        return this.privateConstructor;
    }

    public void setPrivateConstructor(Constructor<T> privateConstructor) {
        this.privateConstructor = privateConstructor;
    }

    public Constructor<T> getConstructor(Class<?> ... parameterTypes) {
        StringBuilder sb = new StringBuilder();
        for (Class<?> parameterType : parameterTypes) {
            String canonicalName = parameterType.getCanonicalName();
            sb.append(canonicalName);
        }
        String cacheKey = sb.toString();
        Constructor<Object> constructor = null;
        if (this.constructors != null) {
            constructor = this.constructors.get(cacheKey);
        }
        if (constructor == null) {
            try {
                if (parameterTypes.length > 0) {
                    for (Constructor<?> c : this.clazz.getConstructors()) {
                        if (c.getParameterCount() != parameterTypes.length) continue;
                        Class<?>[] ps = c.getParameterTypes();
                        boolean isTrue = true;
                        for (int i = 0; i < ps.length; ++i) {
                            Class<?> p = ps[i];
                            boolean same = ClassUtil.isAssignableFrom(p, parameterTypes[i]);
                            if (same) continue;
                            isTrue = false;
                            break;
                        }
                        if (!isTrue) continue;
                        constructor = c;
                        break;
                    }
                } else {
                    constructor = this.clazz.getConstructor(new Class[0]);
                }
                constructor.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (this.constructors == null) {
                this.constructors = Maps.newConcurrentMap();
            }
            this.constructors.put(cacheKey, constructor);
        }
        return constructor;
    }

    public Field getField(String key) {
        Object targetField = null;
        if (this.fieldMap != null) {
            targetField = this.fieldMap.get(key);
        }
        if (targetField == null) {
            Set<Field> fields = this.getAllField();
            ConcurrentMap targetFields = Maps.newConcurrentMap();
            String targetFieldName = StringUtil.camelToMatchesRegex(key);
            for (Field field : fields) {
                if (!PatternUtil.matches(targetFieldName, field.getName(), 2)) continue;
                targetFields.put(field.getName(), field);
            }
            targetField = targetFields.containsKey(key) ? (Field)targetFields.get(key) : (targetFields.isEmpty() ? null : (Field)targetFields.values().iterator().next());
            if (targetField != null) {
                if (!((AccessibleObject)targetField).isAccessible()) {
                    ((Field)targetField).setAccessible(true);
                }
                if (this.fieldMap == null) {
                    this.fieldMap = Maps.newConcurrentMap();
                }
                this.fieldMap.put(key, (Field)targetField);
            }
        }
        return targetField;
    }

    public void parsingGeneric(Field targetField) {
        if (targetField == null) {
            return;
        }
        try {
            Method getGenericInfoMethod = Field.class.getDeclaredMethod("getGenericInfo", new Class[0]);
            getGenericInfoMethod.setAccessible(true);
            getGenericInfoMethod.invoke((Object)targetField, new Object[0]);
        }
        catch (Exception getGenericInfoMethod) {
            // empty catch block
        }
        Object genericInfo = ObjectUtil.getFieldValue((Object)targetField, "genericInfo");
        if (genericInfo == null) {
            return;
        }
        Type genericType = targetField.getGenericType();
        try {
            Type value = this.switchParseType(genericType);
            Field genericTypeField = ClassUtil.getField(FieldRepository.class, "genericType");
            genericTypeField.setAccessible(true);
            ObjectUtil.setValue(genericInfo, genericTypeField, value);
            Field typeField = ClassUtil.getField(Field.class, "type");
            typeField.setAccessible(true);
            ObjectUtil.setValue(targetField, typeField, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Type parseType(TypeVariable<?> typeVariable) {
        Type value = this.typeVariableClassMap.get(typeVariable.getName());
        if (value == null) {
            return typeVariable;
        }
        return value;
    }

    private Type parseType(ParameterizedType parameterizedType) {
        ArrayList<Type> list = new ArrayList<Type>();
        for (Type type : parameterizedType.getActualTypeArguments()) {
            Type switchParseType = this.switchParseType(type);
            list.add(switchParseType);
        }
        Type[] upperBounds = list.toArray(new Type[0]);
        return TypeUtils.parameterizeWithOwner((Type)parameterizedType.getOwnerType(), (Class)((Class)parameterizedType.getRawType()), (Type[])upperBounds);
    }

    private Type parseType(GenericArrayType parameterizedType) {
        return this.switchParseType(parameterizedType.getGenericComponentType());
    }

    private Type parseType(WildcardType wildcardType) {
        ArrayList<Type> list = new ArrayList<Type>();
        for (Type type : wildcardType.getUpperBounds()) {
            Type switchParseType = this.switchParseType(type);
            list.add(switchParseType);
        }
        Type[] upperBounds = list.toArray(new Type[0]);
        ArrayList<Type> result = new ArrayList<Type>();
        for (Type type : wildcardType.getLowerBounds()) {
            Type switchParseType = this.switchParseType(type);
            result.add(switchParseType);
        }
        Type[] lowerBounds = result.toArray(new Type[0]);
        return TypeUtils.wildcardType().withUpperBounds(upperBounds).withLowerBounds(lowerBounds).build();
    }

    private Type switchParseType(Type upperBound) {
        if (upperBound instanceof TypeVariable) {
            return this.parseType((TypeVariable)upperBound);
        }
        if (upperBound instanceof WildcardType) {
            return this.parseType((WildcardType)upperBound);
        }
        if (upperBound instanceof ParameterizedType) {
            return this.parseType((ParameterizedType)upperBound);
        }
        if (upperBound instanceof GenericArrayType) {
            return this.parseType((GenericArrayType)upperBound);
        }
        return upperBound;
    }

    public Method getMethod(String methodName, Class<?> ... paramTypes) {
        Method[] methods;
        StringBuilder sb = new StringBuilder();
        for (Class<?> paramType : paramTypes) {
            Method[] canonicalName = paramType.getCanonicalName();
            sb.append((String)canonicalName);
        }
        String cacheKey = methodName + sb;
        Method targetMethod = null;
        if (this.methodMap != null) {
            targetMethod = this.methodMap.get(cacheKey);
        }
        if (targetMethod != null) {
            return targetMethod;
        }
        HashSet<Method> candidates = new HashSet<Method>(1);
        for (Method method : methods = this.clazz.getMethods()) {
            if (!methodName.equals(method.getName()) || !Arrays.equals(method.getParameterTypes(), paramTypes)) continue;
            candidates.add(method);
        }
        if (candidates.size() == 1) {
            targetMethod = (Method)candidates.iterator().next();
        } else {
            if (candidates.isEmpty()) {
                log.debug("Expected method not found: " + this.clazz.getName() + '.' + methodName);
                return null;
            }
            Optional<Method> any = Optional.empty();
            for (Method c : candidates) {
                if (c.getDeclaringClass() != this.clazz) continue;
                any = Optional.of(c);
                break;
            }
            targetMethod = any.orElseGet(() -> (Method)candidates.iterator().next());
        }
        if (!targetMethod.isAccessible()) {
            targetMethod.setAccessible(true);
        }
        if (this.methodMap == null) {
            this.methodMap = Maps.newConcurrentMap();
        }
        this.methodMap.put(cacheKey, targetMethod);
        return targetMethod;
    }

    public void parsingGeneric(Method targetMethod) {
        try {
            Method getGenericInfoMethod = Method.class.getDeclaredMethod("getGenericInfo", new Class[0]);
            getGenericInfoMethod.setAccessible(true);
            getGenericInfoMethod.invoke((Object)targetMethod, new Object[0]);
        }
        catch (Exception getGenericInfoMethod) {
            // empty catch block
        }
        try {
            this.setParameterTypes(targetMethod);
            this.setReturnType(targetMethod);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setReturnType(Method targetMethod) throws NoSuchFieldException, IllegalAccessException {
        Field genericInfoField = Method.class.getDeclaredField("genericInfo");
        genericInfoField.setAccessible(true);
        Object genericInfo = genericInfoField.get(targetMethod);
        if (genericInfo == null) {
            return;
        }
        Type genericReturnType = targetMethod.getGenericReturnType();
        try {
            Type v = this.switchParseType(genericReturnType);
            Field returnType = MethodRepository.class.getDeclaredField("returnType");
            returnType.setAccessible(true);
            returnType.set(genericInfo, v);
            Field returnTypeField = Method.class.getDeclaredField("returnType");
            returnTypeField.setAccessible(true);
            returnTypeField.set(targetMethod, v);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setParameterTypes(Method targetMethod) throws NoSuchFieldException, IllegalAccessException {
        Field parameterTypes;
        Type[] genericParameterTypes = targetMethod.getGenericParameterTypes();
        Type[] types = new Type[genericParameterTypes.length];
        for (int i = 0; i < types.length; ++i) {
            Type t = genericParameterTypes[i];
            Type v = this.switchParseType(t);
            types[i] = v = v == null ? t : v;
        }
        int size = types.length;
        if (size == 0) {
            return;
        }
        Field genericInfoField = Method.class.getDeclaredField("genericInfo");
        genericInfoField.setAccessible(true);
        Object genericInfo = genericInfoField.get(targetMethod);
        if (genericInfo == null) {
            return;
        }
        try {
            parameterTypes = MethodRepository.class.getSuperclass().getDeclaredField("paramTypes");
        }
        catch (NoSuchFieldException e) {
            parameterTypes = MethodRepository.class.getSuperclass().getDeclaredField("parameterTypes");
        }
        parameterTypes.setAccessible(true);
        parameterTypes.set(genericInfo, types);
        Field methodParameterTypes = Method.class.getDeclaredField("parameterTypes");
        methodParameterTypes.setAccessible(true);
        Class[] classes = new Class[size];
        for (int i = 0; i < size; ++i) {
            Type type = types[i];
            if (!(type instanceof Class)) {
                return;
            }
            classes[i] = (Class)type;
        }
        methodParameterTypes.set(targetMethod, classes);
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Set<Field> getAllField() {
        if (this.allField == null) {
            this.allField = Sets.newConcurrentHashSet();
        }
        if (this.allField.isEmpty()) {
            ClassInfo.extractFieldRecursion(this.clazz, this.allField);
            for (Field field : this.allField) {
                field.setAccessible(true);
                this.parsingGeneric(field);
            }
        }
        return this.allField;
    }

    public synchronized Set<Method> getAllMethod() {
        if (this.allMethod == null) {
            this.allMethod = Sets.newConcurrentHashSet();
        }
        if (this.allMethod.isEmpty()) {
            ClassInfo.extractMethodRecursion(this.clazz, this.allMethod);
        }
        if (!this.parsed) {
            this.allMethod.forEach(method -> {
                method.setAccessible(true);
                this.parsingGeneric((Method)method);
            });
            this.parsed = true;
        }
        return this.allMethod;
    }

    public FieldInfo getFieldInfo(Field field) {
        FieldInfo fieldInfo;
        if (this.fieldInfoCache == null) {
            this.fieldInfoCache = Maps.newConcurrentMap();
        }
        if ((fieldInfo = this.fieldInfoCache.get(field)) == null) {
            fieldInfo = new FieldInfo();
            this.fieldInfoCache.put(field, fieldInfo);
        }
        return fieldInfo;
    }
}

