/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.stream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamUtil {
    private static final Log log = LogFactory.getLog(StreamUtil.class);

    private StreamUtil() {
    }

    public static String toString(InputStream inputStream) {
        return StreamUtil.toString(inputStream, Charset.defaultCharset());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String toString(InputStream inputStream, Charset charset) {
        try (ByteArrayOutputStream result = new ByteArrayOutputStream();){
            StreamUtil.toOutputStream(inputStream, result);
            String string = result.toString(charset.name());
            return string;
        }
        catch (IOException e) {
            log.error((Object)"InputStream convert to String error", (Throwable)e);
            return null;
        }
    }

    public static void toOutputStream(InputStream inputStream, OutputStream outputStream) {
        try {
            int r;
            int length = 1024;
            byte[] buffer = new byte[1024];
            while ((r = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, r);
            }
            outputStream.flush();
        }
        catch (IOException e) {
            log.error((Object)"InputStream convert to OutputStream error", (Throwable)e);
        }
    }
}

