/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.security;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class AesUtil {
    private static final String ALGORITHM = "AES";
    private static final String AES_CBC_PKCS_5_PADDING = "AES/CBC/PKCS5Padding";

    public static String binary(byte[] bytes, int radix) {
        return new BigInteger(1, bytes).toString(radix);
    }

    public static String base64Encode(byte[] bytes) {
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static byte[] base64Decode(String base64Code) {
        return StringUtils.isEmpty((CharSequence)base64Code) ? null : Base64.decodeBase64((String)base64Code);
    }

    public static byte[] aesEncryptToBytes(String content, String encryptKey, String encryptIv, String algorithmstr) throws NoSuchPaddingException, NoSuchAlgorithmException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException {
        byte[] raw = encryptKey.getBytes(StandardCharsets.UTF_8);
        SecretKeySpec secretKeySpec = new SecretKeySpec(raw, ALGORITHM);
        Cipher cipher = Cipher.getInstance(algorithmstr);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(encryptIv.getBytes(StandardCharsets.UTF_8));
        cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
        return cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
    }

    public static String aesEncrypt(String content, String encryptKey, String encryptIv, String algorithmstr) throws NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        return StringUtils.isEmpty((CharSequence)content) ? null : AesUtil.base64Encode(AesUtil.aesEncryptToBytes(content, encryptKey, encryptIv, algorithmstr));
    }

    public static String aesDecryptByBytes(byte[] encryptBytes, String decryptKey, String encryptIv, String algorithmstr) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        byte[] raw = decryptKey.getBytes(StandardCharsets.US_ASCII);
        SecretKeySpec skeySpec = new SecretKeySpec(raw, ALGORITHM);
        Cipher cipher = Cipher.getInstance(algorithmstr);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(encryptIv.getBytes(StandardCharsets.UTF_8));
        cipher.init(2, (Key)skeySpec, ivParameterSpec);
        byte[] decryptBytes = cipher.doFinal(encryptBytes);
        return new String(decryptBytes, StandardCharsets.UTF_8);
    }

    public static String aesEncrypt(String content, String encryptKey, String encryptIv) throws NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException {
        return AesUtil.aesEncrypt(content, encryptKey, encryptIv, AES_CBC_PKCS_5_PADDING);
    }

    public static String aesDecryptByBytes(byte[] encryptBytes, String decryptKey, String encryptIv) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, BadPaddingException, IllegalBlockSizeException {
        return AesUtil.aesDecryptByBytes(encryptBytes, decryptKey, encryptIv, AES_CBC_PKCS_5_PADDING);
    }

    public static String aesDecrypt(String encryptStr, String decryptKey, String encryptIv) {
        return AesUtil.aesDecrypt(encryptStr, decryptKey, encryptIv, AES_CBC_PKCS_5_PADDING);
    }

    public static String aesDecrypt(String encryptStr, String decryptKey, String encryptIv, String algorithmstr) {
        try {
            return StringUtils.isEmpty((CharSequence)encryptStr) ? null : AesUtil.aesDecryptByBytes(AesUtil.base64Decode(encryptStr), decryptKey, encryptIv, algorithmstr);
        }
        catch (Exception e) {
            return encryptStr;
        }
    }
}

