/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.properties;

import cloud.agileframework.common.util.array.ArrayUtil;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.file.JarUtil;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.common.util.stream.StreamUtil;
import cloud.agileframework.common.util.string.StringUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yaml.snakeyaml.Yaml;

public class PropertiesUtil {
    private static final String CLASS = ".class";
    private static final String CLASSES_DIR_SPLIT = "/";
    private static final String DIR_SPLIT = "\\";
    private static final String PROPERTIES_KEY_SPLIT = ".";
    private static final String[] OVERRIDE_CONFIG = new String[]{"application"};
    private static final Log log = LogFactory.getLog(PropertiesUtil.class);
    private static final Properties PROPERTIES = new Properties();
    private static final Set<String> FILE_NAMES = Sets.newHashSet();

    public static void traverseFile(BiConsumer<String, InputStream> consumer) {
        PropertiesUtil.traverseFile(consumer, null);
    }

    public static void traverseFile(BiConsumer<String, InputStream> consumer, String packagePath) {
        if (packagePath == null) {
            PropertiesUtil.readJar("cloud.agileframework.conf", consumer);
            PropertiesUtil.readJar("com.agile.conf", consumer);
            String className = ((StackTraceElement)ArrayUtil.last(new RuntimeException().getStackTrace())).getClassName();
            PropertiesUtil.readJar(className.substring(0, className.lastIndexOf(PROPERTIES_KEY_SPLIT)), consumer);
        } else {
            PropertiesUtil.readJar(packagePath, consumer);
        }
        PropertiesUtil.readDir(consumer);
    }

    private static void parsePlaceholder() {
        for (Map.Entry<Object, Object> v : PROPERTIES.entrySet()) {
            if (!(v.getValue() instanceof String)) continue;
            PROPERTIES.setProperty(String.valueOf(v.getKey()), StringUtil.parsingPlaceholder("${", "}", String.valueOf(v.getValue()), PROPERTIES));
        }
    }

    private static void readDir(BiConsumer<String, InputStream> consumer) {
        HashSet fileNames = Sets.newHashSet();
        HashSet overrideConfigFileNames = Sets.newHashSet();
        try {
            Collections.list(PropertiesUtil.class.getClassLoader().getResources("")).forEach(url -> {
                try {
                    PropertiesUtil.readDir(fileNames, new File(URLDecoder.decode(url.getPath(), StandardCharsets.UTF_8.name())), consumer);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            });
            String classPath = PropertiesUtil.class.getResource(CLASSES_DIR_SPLIT).getPath();
            fileNames.stream().filter(PropertiesUtil.filterOverrideConfigName(overrideConfigFileNames)).sorted(PropertiesUtil.getStringComparator()).forEach(PropertiesUtil.toRead(classPath, consumer));
            overrideConfigFileNames.stream().sorted(PropertiesUtil.getStringComparator()).forEach(PropertiesUtil.toRead(classPath, consumer));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Consumer<String> toRead(String classPath, BiConsumer<String, InputStream> consumer) {
        return fileName -> {
            try {
                PropertiesUtil.read(fileName.replace(URLDecoder.decode(classPath, StandardCharsets.UTF_8.name()), "").replace(DIR_SPLIT, CLASSES_DIR_SPLIT), new FileInputStream(new File((String)fileName)), consumer);
            }
            catch (FileNotFoundException | UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        };
    }

    private static Comparator<String> getStringComparator() {
        return (a, b) -> {
            String regex = "[\\\\/]";
            int s = b.split("[\\\\/]").length - a.split("[\\\\/]").length;
            if (s == 0) {
                s = a.compareTo((String)b);
            }
            return s;
        };
    }

    private static Predicate<String> filterOverrideConfigName(Set<String> overrideConfigFileNames) {
        return name -> {
            for (String overrideConfigName : OVERRIDE_CONFIG) {
                if (!name.contains(overrideConfigName + PROPERTIES_KEY_SPLIT)) continue;
                overrideConfigFileNames.add((String)name);
                return false;
            }
            return true;
        };
    }

    private static void readDir(Set<String> fileNames, File dir, BiConsumer<String, InputStream> consumer) {
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files == null) {
                return;
            }
            for (File file : files) {
                if (file.isFile() && !file.getName().endsWith(CLASS)) {
                    try {
                        fileNames.add(URLDecoder.decode(file.toURI().getPath(), StandardCharsets.UTF_8.name()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!file.isDirectory()) continue;
                PropertiesUtil.readDir(fileNames, file, consumer);
            }
        }
    }

    public static void readJar(String packagePath) {
        PropertiesUtil.readJar(packagePath, PropertiesUtil::toProperties);
    }

    public static void readJar(String packagePath, BiConsumer<String, InputStream> consumer) {
        Set<String> resourceNames = JarUtil.getFile(packagePath, false, CLASS);
        HashSet overrideConfigFileNames = Sets.newHashSet();
        resourceNames.stream().filter(PropertiesUtil.filterOverrideConfigName(overrideConfigFileNames)).sorted(PropertiesUtil.getStringComparator()).forEach(resourceName -> PropertiesUtil.read(resourceName, PropertiesUtil.class.getResourceAsStream((String)resourceName), consumer));
        overrideConfigFileNames.stream().sorted(PropertiesUtil.getStringComparator()).forEach(resourceName -> PropertiesUtil.read(resourceName, PropertiesUtil.class.getResourceAsStream((String)resourceName), consumer));
    }

    public static void read(String fileName, InputStream inputStream) {
        PropertiesUtil.read(fileName, inputStream, PropertiesUtil::toProperties);
    }

    public static void read(String fileName, InputStream inputStream, BiConsumer<String, InputStream> consumer) {
        if (fileName == null || inputStream == null) {
            return;
        }
        consumer.accept(fileName, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void toProperties(String fileName, InputStream inputStream) {
        try {
            String properties = "properties";
            if (fileName.endsWith("properties")) {
                PropertiesUtil.readProperties(inputStream);
            } else {
                String yml = "yml";
                String yaml = "yaml";
                if (fileName.endsWith("yml") || fileName.endsWith("yaml")) {
                    try {
                        PropertiesUtil.readYml(inputStream);
                    }
                    catch (Exception e) {
                        log.debug((Object)(fileName + " \u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff1a"), (Throwable)e);
                    }
                }
            }
            if (!fileName.endsWith(CLASS)) {
                if (!fileName.startsWith(CLASSES_DIR_SPLIT)) {
                    fileName = CLASSES_DIR_SPLIT + fileName;
                }
                FILE_NAMES.add(fileName);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)fileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)String.format("read file(%s) to properties is error", fileName), (Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void readEnv() {
        PropertiesUtil.readProperties(System.getProperties());
        PropertiesUtil.readProperties(System.getenv());
    }

    private static void readProperties(InputStream in) throws IOException {
        PROPERTIES.load(in);
    }

    private static void readProperties(Map<?, ?> map) {
        if (map == null) {
            return;
        }
        map.forEach((key, value) -> {
            try {
                PROPERTIES.setProperty(key.toString(), String.valueOf(value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private static void readYml(InputStream in) {
        Yaml yaml = new Yaml();
        Map dataMap = (Map)yaml.load(in);
        PropertiesUtil.ymlToMap(PROPERTIES, dataMap, null);
    }

    private static void ymlToMap(Map<Object, Object> allMap, Map<String, Object> map, String parentKey) {
        if (map == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String currentKey = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                if (parentKey == null) {
                    PropertiesUtil.ymlToMap(allMap, (Map)value, currentKey.toString());
                    continue;
                }
                PropertiesUtil.ymlToMap(allMap, (Map)value, parentKey + PROPERTIES_KEY_SPLIT + currentKey.toString());
                continue;
            }
            if (value == null) continue;
            if (parentKey == null) {
                allMap.put(currentKey.toString(), value.toString());
            }
            if (parentKey == null) continue;
            allMap.put(parentKey + PROPERTIES_KEY_SPLIT + currentKey.toString(), value.toString());
        }
    }

    public static Properties getProperties() {
        return PROPERTIES;
    }

    public static Set<String> getFileNames() {
        return FILE_NAMES;
    }

    public static void setProperties(String key, String value) {
        if (value == null) {
            return;
        }
        PROPERTIES.setProperty(key, value);
    }

    public static void appendProperties(String key, String value) {
        String v = PROPERTIES.getProperty(key);
        if (v == null) {
            PROPERTIES.setProperty(key, value);
        } else {
            PROPERTIES.setProperty(key, v + value);
        }
    }

    public static String getProperty(String key) {
        Object value = PROPERTIES.get(key);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public static String getProperty(String key, String defaultValue) {
        String value = PropertiesUtil.getProperty(key);
        if (!ObjectUtils.isEmpty((Object)value)) {
            return value.toString();
        }
        return defaultValue;
    }

    public static Properties getPropertyByPrefix(String prefix) {
        Properties properties = new Properties();
        Set<String> propertyNames = PropertiesUtil.getProperties().stringPropertyNames();
        for (String name : propertyNames) {
            if (!name.startsWith(prefix)) continue;
            properties.put(name, PropertiesUtil.getProperties().get(name));
        }
        return properties;
    }

    public static <T> T getProperty(String key, Class<T> clazz) {
        return ObjectUtil.to((Object)PropertiesUtil.getProperty(key), new TypeReference(clazz));
    }

    public static <T> T getProperty(String var1, Class<T> var2, String defaultValue) {
        return ObjectUtil.to((Object)PropertiesUtil.getProperty(var1, defaultValue), new TypeReference(var2));
    }

    public static JSON getJson(String fileName) {
        try {
            InputStream stream = null;
            File file = new File(fileName);
            if (file.exists()) {
                stream = new FileInputStream(file);
            } else {
                String path;
                String suffix = ".json";
                if (!fileName.endsWith(".json")) {
                    fileName = fileName + ".json";
                }
                if ((path = PropertiesUtil.getFileClassPath(fileName)) != null) {
                    stream = PropertiesUtil.class.getResourceAsStream(path);
                }
            }
            if (stream == null) {
                return null;
            }
            return (JSON)JSON.parse((String)StreamUtil.toString(stream));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getFileContent(String fileName) {
        InputStream inputStream = PropertiesUtil.getFileStream(fileName);
        return StreamUtil.toString(inputStream);
    }

    public static InputStream getFileStream(String fileName) {
        String path = PropertiesUtil.getFileClassPath(fileName);
        if (path == null) {
            return null;
        }
        return PropertiesUtil.class.getResourceAsStream(path);
    }

    public static String getFileClassPath(String fileName) {
        String regex = "[\\\\/]";
        Set<String> set = PropertiesUtil.getFilePaths(CLASSES_DIR_SPLIT + fileName);
        return set.stream().min(Comparator.comparingInt(a -> a.split("[\\\\/]").length)).orElse(null);
    }

    public static String getFilePath(String fileName) {
        String path = PropertiesUtil.getFileClassPath(fileName);
        if (path == null) {
            return null;
        }
        URL absolutePath = PropertiesUtil.class.getResource(path);
        if (absolutePath == null) {
            return path;
        }
        try {
            return URLDecoder.decode(absolutePath.getPath(), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return path;
        }
    }

    public static Set<String> getFilePaths(String fileName) {
        return PropertiesUtil.getFileNames().stream().filter(name -> name.endsWith(fileName)).collect(Collectors.toSet());
    }

    static {
        String className = ((StackTraceElement)ArrayUtil.last(new RuntimeException().getStackTrace())).getClassName();
        PropertiesUtil.readJar("cloud.agileframework.conf", PropertiesUtil::toProperties);
        PropertiesUtil.readJar("com.agile.conf", PropertiesUtil::toProperties);
        PropertiesUtil.readJar(className.substring(0, className.lastIndexOf(PROPERTIES_KEY_SPLIT)), PropertiesUtil::toProperties);
        PropertiesUtil.readDir(PropertiesUtil::toProperties);
        PropertiesUtil.readEnv();
        PropertiesUtil.parsePlaceholder();
    }
}

