/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.object;

import cloud.agileframework.common.annotation.Alias;
import cloud.agileframework.common.annotation.CompareField;
import cloud.agileframework.common.annotation.Remark;
import cloud.agileframework.common.util.clazz.ClassInfo;
import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.clazz.FieldInfo;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.date.DateUtil;
import cloud.agileframework.common.util.json.JSONUtil;
import cloud.agileframework.common.util.map.MapUtil;
import cloud.agileframework.common.util.number.NumberUtil;
import cloud.agileframework.common.util.object.DifferentCollectionField;
import cloud.agileframework.common.util.object.DifferentField;
import cloud.agileframework.common.util.object.DifferentRefField;
import cloud.agileframework.common.util.object.DifferentSimpleField;
import cloud.agileframework.common.util.string.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ObjectUtil
extends ObjectUtils {
    private static final String SERIAL_VERSION_UID = "serialVersionUID";

    public static <T> T to(Object from, TypeReference<T> toClass) {
        return ObjectUtil.to(from, toClass, true);
    }

    public static <T> T to(Object from, TypeReference<T> toClass, boolean alias) {
        Object result;
        if (from == null) {
            return null;
        }
        if (toClass.isEnum()) {
            result = ObjectUtil.toEnum(from, toClass);
        } else if (toClass.isArray()) {
            result = ObjectUtil.toArray(from, toClass);
        } else if (toClass.isExtendsFrom(Collection.class)) {
            result = ObjectUtil.toCollection(from, toClass);
        } else if (toClass.isExtendsFrom(Map.class)) {
            result = ObjectUtil.toMap(from, toClass);
        } else if (toClass.isWrapOrPrimitive()) {
            result = ObjectUtil.to(from, toClass.extractWrapOrPrimitive());
        } else if (toClass.isExtendsFrom(String.class)) {
            result = String.valueOf(from);
        } else if (toClass.isExtendsFrom(java.util.Date.class)) {
            GregorianCalendar calendar;
            result = from instanceof java.util.Date ? (toClass.getType() == Timestamp.class ? new Timestamp(((java.util.Date)from).getTime()) : (toClass.getType() == Date.class ? new Date(((java.util.Date)from).getTime()) : new java.util.Date(((java.util.Date)from).getTime()))) : ((calendar = DateUtil.parse(from.toString())) != null ? calendar.getTime() : null);
        } else if (toClass.getType() == from.getClass()) {
            result = from;
        } else {
            Constructor<T> construct2;
            try {
                result = ObjectUtil.toPOJO(from, ClassUtil.getWrapper(toClass.getType()), alias);
            }
            catch (Exception e) {
                result = null;
            }
            if (result == null) {
                try {
                    construct2 = toClass.getConstruct(from.getClass());
                    result = construct2.newInstance(from);
                }
                catch (Exception construct2) {
                    // empty catch block
                }
            }
            if (result == null && ClassUtil.isPrimitive(from.getClass())) {
                try {
                    construct2 = toClass.getConstruct(String.class);
                    result = construct2.newInstance(ObjectUtil.toString(from));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public static String toString(Object from) {
        if (from == null) {
            return null;
        }
        try {
            Method toStringMethod = ClassUtil.getMethod(from.getClass(), "toString", new Class[0]);
            if (toStringMethod != null && toStringMethod.getDeclaringClass() != Object.class) {
                return from.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String result = from.getClass().isArray() ? ArrayUtils.toString((Object)from) : (Collection.class.isAssignableFrom(from.getClass()) ? ArrayUtils.toString((Object)((Collection)from).toArray()) : (from.getClass().isEnum() ? ((Enum)from).name() : Objects.toString(from, null)));
        return result;
    }

    private static <T> T toEnum(Object from, TypeReference<T> toClass) {
        Enum result = null;
        if (toClass.isEnum()) {
            Map map;
            Class<Enum> enumClass = toClass.extractEnum();
            String sourceName = from.getClass().isEnum() ? ((Enum)from).name() : from.toString();
            String targetName = StringUtil.vagueMatches(sourceName, (map = EnumUtils.getEnumMap(enumClass)).keySet());
            if (targetName != null) {
                result = EnumUtils.getEnum(enumClass, (String)targetName);
            }
            if (targetName == null) {
                result = map.values().stream().filter(a -> sourceName.endsWith(a.toString())).findFirst().orElse(null);
            }
        }
        return (T)result;
    }

    private static <T> T toArray(Object from, TypeReference<T> toClass) {
        if (!toClass.isArray()) {
            return null;
        }
        Object array = null;
        Class<?> innerClass = toClass.extractArray();
        if (ClassUtil.isExtendsFrom(from.getClass(), Collection.class)) {
            array = Array.newInstance(innerClass, ((Collection)from).size());
            int i = 0;
            for (Object node : (Collection)from) {
                Array.set(array, i++, ObjectUtil.to(node, new TypeReference<Object>(innerClass){}));
            }
        } else if (from.getClass().isArray()) {
            int length = Array.getLength(from);
            array = Array.newInstance(innerClass, length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, ObjectUtil.to(Array.get(from, i), new TypeReference<Object>(innerClass){}));
            }
        } else if (from instanceof String) {
            try {
                JSONArray jsonArray = JSON.parseArray((String)((String)from));
                return ObjectUtil.to((Object)jsonArray, toClass);
            }
            catch (Exception e) {
                String[] strings = ((String)from).split(",");
                return ObjectUtil.toArray(strings, toClass);
            }
        }
        return (T)array;
    }

    private static <T> T toMap(Object from, TypeReference<T> toClass) {
        if (toClass.isExtendsFrom(Map.class)) {
            if (ClassUtil.isExtendsFrom(from.getClass(), Collection.class) || from.getClass().isArray()) {
                return null;
            }
            Map map = MapUtil.parse(from);
            return (T)MapUtil.toMap(map, toClass);
        }
        return null;
    }

    private static <T> T toCollection(Object from, TypeReference<T> toClass) {
        AbstractCollection collection;
        block9: {
            Object nodeType;
            block10: {
                if (!toClass.isExtendsFrom(Collection.class)) {
                    return null;
                }
                if (from instanceof String) {
                    try {
                        JSONArray array = JSON.parseArray((String)((String)from));
                        return ObjectUtil.toCollection(array, toClass);
                    }
                    catch (Exception e) {
                        String[] strings = ((String)from).split(",");
                        return ObjectUtil.toCollection(strings, toClass);
                    }
                }
                if (!ClassUtil.isExtendsFrom(from.getClass(), Collection.class) && !from.getClass().isArray()) {
                    return null;
                }
                Class<?> wrapperClass = ClassUtil.getWrapper(toClass.getType());
                if (wrapperClass == null) {
                    return null;
                }
                collection = wrapperClass.isInterface() ? (wrapperClass == Queue.class ? new ArrayDeque() : (wrapperClass == BlockingDeque.class ? new LinkedBlockingDeque() : (wrapperClass == BlockingQueue.class ? new LinkedBlockingQueue() : (wrapperClass == Set.class ? new HashSet() : (wrapperClass == SortedSet.class ? new TreeSet() : new ArrayList()))))) : (ArrayDeque)ClassUtil.newInstance(wrapperClass);
                if (collection == null) break block9;
                Type type = toClass.getType();
                nodeType = Object.class;
                if (type instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)type;
                    nodeType = parameterizedType.getActualTypeArguments()[0];
                }
                Class<Object> finalNodeType = nodeType;
                if (!ClassUtil.isExtendsFrom(from.getClass(), Collection.class)) break block10;
                for (Object o : (Collection)from) {
                    collection.add(ObjectUtil.to(o, new TypeReference((Type)nodeType)));
                }
                break block9;
            }
            if (!from.getClass().isArray()) break block9;
            for (Object o : (Object[])from) {
                collection.add(ObjectUtil.to(o, new TypeReference((Type)nodeType)));
            }
        }
        return (T)collection;
    }

    static <T> T toPOJO(Object from, Class<? extends T> toClass, boolean alias) {
        if (from == null) {
            return null;
        }
        Class<?> sourceClass = from.getClass();
        if (toClass.isAssignableFrom(sourceClass)) {
            return (T)from;
        }
        if (Map.class.isAssignableFrom(sourceClass)) {
            Map map = (Map)from;
            T object = ObjectUtil.getObjectFromMap(toClass, map);
            if (object != null && ObjectUtil.isChange(object)) {
                return object;
            }
        } else if (from instanceof String) {
            try {
                Object json = JSON.parse((String)((String)from));
                if (json instanceof JSON) {
                    return ObjectUtil.toPOJO(json, toClass, alias);
                }
            }
            catch (Exception json) {}
        } else {
            if (sourceClass.isPrimitive() || Iterable.class.isAssignableFrom(sourceClass)) {
                return null;
            }
            T object = ClassUtil.newInstance(toClass);
            ObjectUtil.copyProperties(from, object, alias);
            if (ObjectUtil.isChange(object)) {
                return object;
            }
        }
        return null;
    }

    private static <T> T to(Object from, Class<T> toClass) {
        if (from == null) {
            return null;
        }
        Object temp = null;
        if (from.getClass().isArray() && Array.getLength(from) > 0) {
            from = Array.get(from, 0);
        }
        if (Collection.class.isAssignableFrom(from.getClass()) && !((Collection)from).isEmpty()) {
            from = ((Collection)from).iterator().next();
        }
        String valueStr = from.toString();
        if (NumberUtil.isNumber(toClass)) {
            Number number = from instanceof Boolean ? (Number)((Boolean)from != false ? 1 : 0) : (Number)("true".equalsIgnoreCase(valueStr) ? (Number)1 : (Number)("false".equalsIgnoreCase(valueStr) ? (Number)0 : (Number)NumberUtils.createNumber((String)valueStr)));
            if (toClass == Short.class || toClass == Short.TYPE) {
                temp = number.shortValue();
            } else if (toClass == Integer.class || toClass == Integer.TYPE) {
                temp = number.intValue();
            } else if (toClass == Long.class || toClass == Long.TYPE) {
                temp = number.longValue();
            } else if (toClass == Float.class || toClass == Float.TYPE) {
                temp = Float.valueOf(number.floatValue());
            } else if (toClass == Double.class || toClass == Double.TYPE) {
                temp = number.doubleValue();
            } else if (toClass == Byte.class || toClass == Byte.TYPE) {
                temp = number.byteValue();
            }
        } else if (toClass == Boolean.class || toClass == Boolean.TYPE) {
            temp = NumberUtils.isParsable((String)valueStr) ? Boolean.valueOf(NumberUtils.createNumber((String)valueStr).intValue() > 0) : Boolean.valueOf(Boolean.parseBoolean(valueStr));
        } else if (toClass == Byte.class || toClass == Byte.TYPE) {
            temp = Byte.parseByte(valueStr);
        } else if (toClass == Character.class || toClass == Character.TYPE) {
            char[] array = valueStr.toCharArray();
            temp = array.length > 0 ? Character.valueOf(array[0]) : null;
        } else if (toClass == String.class && from.getClass().isPrimitive()) {
            temp = valueStr;
        } else if (toClass == String.class) {
            try {
                temp = JSON.toJSONString((Object)from);
            }
            catch (Exception e) {
                temp = valueStr;
            }
        }
        return (T)temp;
    }

    public static boolean isChange(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        try {
            Object newObject = clazz.newInstance();
            Set haveValueFields = ClassUtil.getAllField(clazz).stream().filter(field -> {
                try {
                    if (SERIAL_VERSION_UID.equals(field.getName())) {
                        return false;
                    }
                    Object currentValue = field.get(object);
                    Object initValue = field.get(newObject);
                    return currentValue != null && !Objects.deepEquals(currentValue, initValue);
                }
                catch (Exception e) {
                    return false;
                }
            }).collect(Collectors.toSet());
            return !haveValueFields.isEmpty();
        }
        catch (IllegalAccessException | InstantiationException e) {
            return true;
        }
    }

    public static void setValue(Object object, Field field, Object value) {
        Class<?> objectClass = object.getClass();
        Class<?> typeTpye = field.getType();
        if (value != null) {
            FieldInfo fieldInfo;
            JSONField annotation = field.getAnnotation(JSONField.class);
            if (annotation != null && annotation.deserializeUsing() != null) {
                try {
                    ObjectDeserializer deserializer = (ObjectDeserializer)ClassUtil.newInstance(annotation.deserializeUsing());
                    assert (deserializer != null);
                    Object v = deserializer.deserialze(new DefaultJSONParser(JSON.toJSONString((Object)value), ParserConfig.global, JSON.DEFAULT_PARSER_FEATURE), field.getType(), (Object)field.getName());
                    if (v != null) {
                        ObjectUtil.setValueIfNotNull(object, field, v);
                        return;
                    }
                }
                catch (Exception deserializer) {
                    // empty catch block
                }
            }
            if ((fieldInfo = ClassInfo.getCache(objectClass).getFieldInfo(field)).isNoSetters() == null) {
                String fieldName = field.getName();
                String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                Set<Method> allMethod = ClassUtil.getAllMethod(objectClass);
                List list = allMethod.stream().filter(method -> setMethodName.equals(method.getName()) && method.getParameterCount() == 1).sorted((a, b) -> {
                    int result = b.getName().compareTo(a.getName());
                    if (result == 0) {
                        int aI = typeTpye == a.getParameterTypes()[0] ? 1 : 0;
                        int bI = typeTpye == b.getParameterTypes()[0] ? 1 : 0;
                        result = bI - aI;
                    }
                    return result;
                }).map(method -> {
                    fieldInfo.putSetter((Method)method);
                    return method;
                }).collect(Collectors.toList());
                fieldInfo.setNoSetters(list.isEmpty());
            }
            if (Boolean.FALSE.equals(fieldInfo.isNoSetters())) {
                List<Method> setters = fieldInfo.setters();
                Object initValue = null;
                try {
                    initValue = field.get(object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (Method setter : setters) {
                    try {
                        ObjectUtil.invokeMethodIfParamNotNull(object, setter, value);
                        Object newValue = field.get(object);
                        if (newValue == null || newValue.equals(initValue)) continue;
                        fieldInfo.putSetter(setter);
                        return;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            try {
                ObjectUtil.setValueIfNotNull(object, field, value);
            }
            catch (Exception exception) {}
        } else if (!typeTpye.isPrimitive()) {
            try {
                field.set(object, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void invokeMethodIfParamNotNull(Object object, Method method, Object value) throws InvocationTargetException, IllegalAccessException {
        Type[] parameterTypes = method.getGenericParameterTypes();
        if (parameterTypes.length == 1) {
            Object v = ObjectUtil.to(value, new TypeReference(parameterTypes[0]));
            if (value != null && v == null) {
                throw new RuntimeException();
            }
            method.invoke(object, v);
        }
    }

    public static void setValueIfNotNull(Object object, Field field, Object value) throws IllegalAccessException {
        Object v = ObjectUtil.to(value, new TypeReference(field.getGenericType()));
        if (value != null && v == null) {
            throw new RuntimeException();
        }
        field.set(object, v);
    }

    public static void copyProperties(Object source, Object target, Compare compare) {
        ObjectUtil.copyProperties(source, target, "", "", new String[0], ContainOrExclude.EXCLUDE, compare, false);
    }

    private static Map<Field, Set<Field>> getSameField(Object source, Object target, String prefix, String suffix, Compare compare, boolean isAlias) {
        Map<Object, Object> result = Maps.newConcurrentMap();
        if (ObjectUtils.isEmpty((Object)source) || ObjectUtils.isEmpty((Object)target)) {
            return result;
        }
        result = isAlias ? ObjectUtil.getSameFieldByAlias(source.getClass(), target.getClass(), prefix, suffix) : ObjectUtil.getSameFieldByBlurry(source.getClass(), target.getClass(), prefix, suffix);
        if (result.isEmpty()) {
            return result;
        }
        ObjectUtil.parseCompare(source, target, compare, result);
        return result;
    }

    private static void parseCompare(Object source, Object target, Compare compare, Map<Field, Set<Field>> result) {
        Object targetNew = null;
        try {
            targetNew = target.getClass().newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object finalTargetNew = targetNew;
        Iterator<Map.Entry<Field, Set<Field>>> resultIt = result.entrySet().iterator();
        while (resultIt.hasNext()) {
            Map.Entry<Field, Set<Field>> e = resultIt.next();
            Field toField = e.getKey();
            Set<Field> fromFields = e.getValue();
            boolean is = false;
            block14: for (Field fromField : fromFields) {
                Object sourceValue = ObjectUtil.getFieldValue(source, fromField);
                Object targetValue = ObjectUtil.getFieldValue(target, toField);
                switch (compare) {
                    case DIFF_ALL_NOT_NULL: {
                        if (sourceValue == null || targetValue == null || ObjectUtil.equals(sourceValue, targetValue)) break;
                        continue block14;
                    }
                    case DIFF_TARGET_NULL: {
                        if (sourceValue == null || targetValue != null) break;
                        continue block14;
                    }
                    case DIFF_SOURCE_NULL: {
                        if (sourceValue != null || targetValue == null) break;
                        continue block14;
                    }
                    case DIFF_SOURCE_NOT_NULL: {
                        if (sourceValue == null || ObjectUtil.equals(sourceValue, targetValue)) break;
                        continue block14;
                    }
                    case DIFF_TARGET_NOT_NULL: {
                        if (targetValue == null || ObjectUtil.equals(sourceValue, targetValue)) break;
                        continue block14;
                    }
                    case DIFF_SOURCE_NOT_NULL_AND_TARGET_DEFAULT: {
                        if (finalTargetNew == null) {
                            throw new RuntimeException(String.format("\u76ee\u6807\u5bf9\u8c61\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7c7b\u201c%s\u201d\u662f\u5426\u5305\u542b\u7a7a\u53c2\u6784\u9020\u51fd\u6570", target.getClass()));
                        }
                        if (sourceValue == null || ObjectUtil.equals(sourceValue, targetValue) || !ObjectUtil.equals(ObjectUtil.getFieldValue(finalTargetNew, toField), targetValue)) break;
                        continue block14;
                    }
                    case DIFF_TARGET_DEFAULT: {
                        if (finalTargetNew == null) {
                            throw new RuntimeException(String.format("\u76ee\u6807\u5bf9\u8c61\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7c7b\u201c%s\u201d\u662f\u5426\u5305\u542b\u7a7a\u53c2\u6784\u9020\u51fd\u6570", target.getClass()));
                        }
                        if (ObjectUtil.equals(sourceValue, targetValue) || !ObjectUtil.equals(ObjectUtil.getFieldValue(finalTargetNew, toField), targetValue)) break;
                        continue block14;
                    }
                    case DIFF: {
                        if (ObjectUtil.equals(sourceValue, targetValue)) break;
                        continue block14;
                    }
                    case SAME: {
                        if (!ObjectUtil.equals(sourceValue, targetValue)) break;
                        continue block14;
                    }
                }
                is = true;
            }
            if (!is) continue;
            resultIt.remove();
        }
    }

    public static boolean equals(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        return object1 != null && object1.equals(object2);
    }

    public static Map<Field, Set<Field>> getSameFieldByBlurry(Class<?> sourceClass, Class<?> targetClass) {
        return ObjectUtil.getSameFieldByBlurry(sourceClass, targetClass, "", "");
    }

    public static Map<Field, Set<Field>> getSameFieldByBlurry(Class<?> sourceClass, Class<?> targetClass, String prefix, String suffix) {
        String finalSuffix;
        ConcurrentMap result = Maps.newConcurrentMap();
        if (ObjectUtils.isEmpty(sourceClass) || ObjectUtils.isEmpty(targetClass)) {
            return result;
        }
        String finalPrefix = prefix == null ? "" : prefix;
        String string = finalSuffix = suffix == null ? "" : suffix;
        if (sourceClass == targetClass) {
            for (Field field : ClassUtil.getAllField(sourceClass)) {
                if (!field.getName().startsWith(finalPrefix) || !field.getName().endsWith(finalPrefix)) continue;
                result.put(field, Sets.newHashSet((Object[])new Field[]{field}));
            }
        } else {
            for (Field toField : ClassUtil.getAllField(targetClass)) {
                String name = toField.getName();
                Field fromField = ClassUtil.getField(sourceClass, name);
                if (fromField == null || !fromField.getName().startsWith(finalPrefix) || !fromField.getName().endsWith(finalSuffix)) continue;
                Set set = (Set)result.get(fromField);
                if (set == null) {
                    set = Sets.newHashSet();
                }
                set.add(toField);
                result.put(fromField, set);
            }
        }
        return result;
    }

    public static Map<Field, Set<Field>> getSameFieldByAlias(Class<?> sourceClass, Class<?> targetClass) {
        return ObjectUtil.getSameFieldByAlias(sourceClass, targetClass, "", "");
    }

    public static Map<Field, Set<Field>> getSameFieldByAlias(Class<?> sourceClass, Class<?> targetClass, String prefix, String suffix) {
        ConcurrentMap map = Maps.newConcurrentMap();
        if (ObjectUtils.isEmpty(sourceClass) || ObjectUtils.isEmpty(targetClass)) {
            return map;
        }
        String finalPrefix = prefix == null ? "" : prefix;
        String finalSuffix = suffix == null ? "" : suffix;
        Map<Field, Set<String>> sourceMap = ObjectUtil.parseFieldAlias(sourceClass);
        Map<Field, Set<String>> targetMap = ObjectUtil.parseFieldAlias(targetClass);
        targetMap.entrySet().stream().filter(e -> {
            String name = ((Field)e.getKey()).getName();
            return name.startsWith(finalPrefix) && name.endsWith(finalSuffix);
        }).forEach(e -> {
            Set targetAlias = (Set)e.getValue();
            HashSet<Field> set = new HashSet<Field>();
            for (Map.Entry te : sourceMap.entrySet()) {
                if (CollectionUtils.retainAll((Collection)((Collection)te.getValue()), (Collection)targetAlias).isEmpty()) continue;
                Field key = (Field)te.getKey();
                set.add(key);
            }
            map.put(e.getKey(), set);
        });
        return map;
    }

    public static Map<Field, Set<String>> parseFieldAlias(Class<?> sourceClass) {
        ConcurrentMap sourceMap = Maps.newConcurrentMap();
        Set<ClassUtil.Target<Alias>> sourceAnnotations = ClassUtil.getAllEntityAnnotation(sourceClass, Alias.class);
        for (Field field : ClassUtil.getAllField(sourceClass)) {
            HashSet aliases;
            ClassUtil.Target<Alias> an = null;
            for (ClassUtil.Target<Alias> sourceAnnotation : sourceAnnotations) {
                if (sourceAnnotation.getMember() != field) continue;
                an = sourceAnnotation;
                break;
            }
            if (an != null) {
                aliases = Sets.newHashSet((Object[])((Alias)an.getAnnotation()).value());
                aliases.add(field.getName());
            } else {
                aliases = Sets.newHashSet((Object[])new String[]{field.getName()});
            }
            sourceMap.put(field, aliases);
        }
        return sourceMap;
    }

    public static void copyProperties(Object source, Object target, String[] arguments, ContainOrExclude containOrExclude) {
        ObjectUtil.copyProperties(source, target, "", "", arguments, containOrExclude, Compare.DIFF, false);
    }

    public static void copyProperties(Object source, Object target, String prefix, String suffix) {
        ObjectUtil.copyProperties(source, target, prefix, suffix, new String[0], ContainOrExclude.EXCLUDE, Compare.DIFF, false);
    }

    public static void copyProperties(Object source, Object target) {
        ObjectUtil.copyProperties(source, target, "", "", new String[0], ContainOrExclude.EXCLUDE, Compare.DIFF, false);
    }

    public static void copyProperties(Object source, Object target, boolean alias) {
        ObjectUtil.copyProperties(source, target, "", "", new String[0], ContainOrExclude.EXCLUDE, Compare.DIFF, alias);
    }

    public static void copyProperties(Object source, Object target, String prefix, String suffix, String[] arguments, ContainOrExclude containOrExclude, Compare compare, boolean isAlias) {
        if (ObjectUtils.isEmpty((Object)source) || ObjectUtils.isEmpty((Object)target)) {
            return;
        }
        Map<Field, Set<Field>> argumentsMap = ObjectUtil.getSameField(source, target, prefix, suffix, compare, isAlias);
        argumentsMap.entrySet().forEach(e -> {
            try {
                Field toField = (Field)e.getKey();
                if (((Set)e.getValue()).isEmpty()) {
                    Alias alias = ClassUtil.getFieldAnnotation(target.getClass(), toField.getName(), Alias.class);
                    if (alias != null) {
                        for (String alia : alias.value()) {
                            Object value = JSONUtil.pathGet(alia, source);
                            Type type = toField.getGenericType();
                            TypeReference typeReference = new TypeReference(type);
                            if (value != null) {
                                value = ObjectUtil.to(value, typeReference);
                            }
                            ObjectUtil.setValue(target, toField, value);
                        }
                    }
                    return;
                }
                for (Field fromField : (Set)e.getValue()) {
                    switch (containOrExclude) {
                        case EXCLUDE: {
                            if (!ArrayUtils.contains((Object[])arguments, (Object)fromField.getName())) break;
                            return;
                        }
                        case INCLUDE: {
                            if (ArrayUtils.contains((Object[])arguments, (Object)fromField.getName())) break;
                            return;
                        }
                    }
                    Object value = fromField.get(source);
                    Type type = toField.getGenericType();
                    TypeReference typeReference = new TypeReference(type);
                    if (value != null) {
                        value = ObjectUtil.to(value, typeReference);
                    }
                    ObjectUtil.setValue(target, toField, value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static Object getFieldValue(Object o, String fieldName) {
        if (o == null) {
            return null;
        }
        Field field = ClassUtil.getField(o.getClass(), fieldName);
        if (field == null) {
            return null;
        }
        return ObjectUtil.getFieldValue(o, field);
    }

    public static Object getFieldValue(Object o, Field field) {
        if (field == null) {
            return null;
        }
        FieldInfo fieldInfo = ClassInfo.getCache(o.getClass()).getFieldInfo(field);
        if (fieldInfo.isNoGetters() == null) {
            List methods;
            String fieldName = field.getName();
            String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            if (field.getType() == Boolean.TYPE) {
                String getMethodName2 = "is" + StringUtil.toUpperName(field.getName());
                methods = ClassInfo.getCache(o.getClass()).getAllMethod().stream().filter(method -> (method.getName().equals(getMethodName) || method.getName().equals(getMethodName2)) && method.getParameterCount() == 0).map(method -> {
                    fieldInfo.putGetter((Method)method);
                    return method;
                }).collect(Collectors.toList());
            } else {
                methods = ClassInfo.getCache(o.getClass()).getAllMethod().stream().filter(method -> method.getName().equals(getMethodName) && method.getParameterCount() == 0).map(method -> {
                    fieldInfo.putGetter((Method)method);
                    return method;
                }).collect(Collectors.toList());
            }
            if (!methods.isEmpty()) {
                for (Method method2 : methods) {
                    try {
                        Object v = method2.invoke(o, new Object[0]);
                        fieldInfo.putGetter(method2);
                        return v;
                    }
                    catch (Exception exception) {
                    }
                }
            } else {
                fieldInfo.setNoGetters(true);
            }
        }
        if (Boolean.FALSE.equals(fieldInfo.isNoGetters())) {
            List<Method> getters = fieldInfo.getters();
            for (Method getter : getters) {
                try {
                    Object v = getter.invoke(o, new Object[0]);
                    fieldInfo.putGetter(getter);
                    return v;
                }
                catch (Exception exception) {
                }
            }
        }
        try {
            return field.get(o);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static <T> T getObjectFromMap(Class<T> clazz, Map<?, ?> map) {
        return ObjectUtil.getObjectFromMap(clazz, map, "", "");
    }

    public static <T> T getObjectFromMap(Class<T> clazz, Map<String, Object> map, String prefix) {
        return ObjectUtil.getObjectFromMap(clazz, map, prefix, "");
    }

    public static <T> T getObjectFromMap(Class<T> clazz, Map<?, ?> map, String prefix, String suffix) {
        if (Map.class.isAssignableFrom(clazz)) {
            return (T)map;
        }
        if (!ObjectUtils.isEmpty(map)) {
            Object object = ClassUtil.newInstance(clazz);
            Set<Field> fields = ClassUtil.getAllField(clazz);
            fields.forEach(field -> {
                String key = ObjectUtil.coverFieldNameToMapKey(clazz, field, prefix, suffix, map);
                if (key != null) {
                    try {
                        Object value = map.get(key);
                        ObjectUtil.setValue(object, field, value);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            });
            if (!ObjectUtil.isAllNullValidity(object)) {
                return object;
            }
        }
        return null;
    }

    public static String coverFieldNameToMapKey(Class<?> clazz, Field field, String prefix, String suffix, Map<?, ?> map) {
        String key = null;
        String propertyName = prefix + field.getName() + suffix;
        if (map.containsKey(propertyName)) {
            return propertyName;
        }
        Alias column = null;
        try {
            column = ObjectUtil.getAllEntityPropertyAnnotation(clazz, field, Alias.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (column != null) {
            for (String alias : column.value()) {
                if (!map.containsKey(alias)) continue;
                key = alias;
                break;
            }
        }
        if (key != null) {
            return key;
        }
        HashSet<String> keys = new HashSet<String>();
        for (Object o : map.keySet()) {
            String toString = o.toString();
            keys.add(toString);
        }
        key = StringUtil.vagueMatches(propertyName, keys);
        if (key != null) {
            return key;
        }
        if (column != null) {
            String alias;
            String[] stringArray = column.value();
            int n = stringArray.length;
            for (int i = 0; i < n && (key = StringUtil.vagueMatches(alias = stringArray[i], keys)) == null; ++i) {
            }
        }
        return key;
    }

    public static <T extends Annotation> T getAllEntityPropertyAnnotation(Class<?> clazz, Field field, Class<T> annotation) throws NoSuchMethodException {
        T result = null;
        T fieldDeclaredAnnotations = field.getDeclaredAnnotation(annotation);
        if (fieldDeclaredAnnotations != null) {
            return fieldDeclaredAnnotations;
        }
        T fieldAnnotations = field.getAnnotation(annotation);
        if (fieldAnnotations != null) {
            return fieldAnnotations;
        }
        String getMethodName = String.format("get%s", StringUtil.toUpperName(field.getName()));
        try {
            Method declaredMethod = clazz.getDeclaredMethod(getMethodName, new Class[0]);
            T methodDeclaredAnnotations = declaredMethod.getDeclaredAnnotation(annotation);
            if (methodDeclaredAnnotations != null) {
                return methodDeclaredAnnotations;
            }
        }
        catch (Exception declaredMethod) {
            // empty catch block
        }
        try {
            Method method = clazz.getMethod(getMethodName, new Class[0]);
            T methodAnnotations = method.getAnnotation(annotation);
            if (methodAnnotations != null) {
                return methodAnnotations;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean isAllNullValidity(Object object) {
        Class<?> clazz = object.getClass();
        try {
            Object newObject = clazz.newInstance();
            Set haveValueFields = ClassUtil.getAllField(clazz).stream().filter(field -> {
                try {
                    if (SERIAL_VERSION_UID.equals(field.getName())) {
                        return false;
                    }
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    Object currentValue = field.get(object);
                    Object initValue = field.get(newObject);
                    return currentValue != null && currentValue != initValue;
                }
                catch (Exception e) {
                    return false;
                }
            }).collect(Collectors.toSet());
            return haveValueFields.isEmpty();
        }
        catch (IllegalAccessException | InstantiationException e) {
            return false;
        }
    }

    public static void setAllFieldNull(Object object) {
        if (object == null) {
            return;
        }
        for (Field field : ClassUtil.getAllField(object.getClass())) {
            try {
                if (SERIAL_VERSION_UID.equals(field.getName())) continue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                field.set(object, null);
            }
            catch (Exception exception) {}
        }
    }

    public static String objectToString(Object o, String ... exclude) {
        Class<?> clazz = o.getClass();
        StringBuilder target = new StringBuilder(clazz.getSimpleName()).append("{");
        Set<Field> fields = ClassUtil.getAllField(clazz);
        int i = 0;
        for (Field field : fields) {
            try {
                if (ArrayUtils.contains((Object[])exclude, (Object)field.getName())) {
                    ++i;
                    continue;
                }
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                if (i != 0) {
                    target.append(", ");
                }
                target.append(field.getName()).append("='").append(field.get(o));
                if (i == fields.size() - 1) {
                    target.append('}');
                } else {
                    target.append('\'');
                }
            }
            catch (IllegalAccessException e) {
                continue;
            }
            ++i;
        }
        return target.toString();
    }

    public static Map<String, Object> getUnderlineMapFromObject(Object o, String ... excludeField) {
        Set<Field> fields = ClassUtil.getAllField(o.getClass());
        HashSet<Field> set = new HashSet<Field>();
        for (Field field1 : fields) {
            if (ArrayUtils.contains((Object[])excludeField, (Object)field1.getName())) continue;
            set.add(field1);
        }
        fields = set;
        HashMap<String, Object> result = new HashMap<String, Object>(fields.size());
        if (!fields.isEmpty()) {
            fields.forEach(field -> {
                String key = StringUtil.toUnderline(field.getName());
                try {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    result.put(key, field.get(o));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            });
        }
        return result;
    }

    public static List<Map<String, Object>> getUnderlineMapFromListObject(Iterable<Object> list) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (list != null) {
            for (Object o : list) {
                result.add(ObjectUtil.getUnderlineMapFromObject(o, new String[0]));
            }
        }
        return result;
    }

    public static boolean compare(Object source, Object target) {
        return ObjectUtil.isEmpty((Object)source) && ObjectUtil.isEmpty((Object)target) || source.equals(target);
    }

    public static List<DifferentField> getDifferenceProperties(Object source, Object target, String ... excludeProperty) {
        ArrayList<DifferentField> result = new ArrayList<DifferentField>();
        if (source == null && target == null) {
            return result;
        }
        Set<Object> sourceFields = source == null ? Sets.newHashSetWithExpectedSize((int)0) : ClassUtil.getAllField(source.getClass());
        Set<Object> targetFields = target == null ? Sets.newHashSetWithExpectedSize((int)0) : ClassUtil.getAllField(target.getClass());
        HashSet<String> willResolveFieldNames = new HashSet<String>();
        for (Set fields : Arrays.asList(sourceFields, targetFields)) {
            for (Field field : fields) {
                String a = field.getName();
                if (ArrayUtils.contains((Object[])excludeProperty, (Object)a)) continue;
                willResolveFieldNames.add(a);
            }
        }
        for (String fieldName : willResolveFieldNames) {
            DifferentField differentField = ObjectUtil.resolve(source, target, fieldName);
            if (differentField == null) continue;
            if (differentField instanceof DifferentRefField) {
                result.addAll(((DifferentRefField)differentField).extractRef());
                continue;
            }
            result.add(differentField);
        }
        return result;
    }

    public static String getDifferencePropertiesDesc(Object source, Object target, String ... excludeProperty) {
        List<DifferentField> difFields = ObjectUtil.getDifferenceProperties(source, target, excludeProperty);
        StringJoiner joiner = new StringJoiner("\n");
        for (DifferentField difField : difFields) {
            String describe = difField.describe();
            joiner.add(describe);
        }
        return joiner.toString();
    }

    public static DifferentField resolve(Object source, Object target, String fieldName) {
        String remark;
        DifferentField result = null;
        if (source == null && target == null) {
            return result;
        }
        Object sourceValue = ObjectUtil.getFieldValue(source, fieldName);
        Object targetValue = ObjectUtil.getFieldValue(target, fieldName);
        if (sourceValue == null && targetValue == null) {
            return result;
        }
        if (Objects.equals(sourceValue, targetValue)) {
            return result;
        }
        Field sourceField = ObjectUtil.getField(source, fieldName);
        Field targetField = ObjectUtil.getField(target, fieldName);
        try {
            remark = ObjectUtil.resolveLogField(source, target, fieldName);
        }
        catch (DifferentField.LogFieldIgnoreException e) {
            return result;
        }
        CompareField sourceCompareField = ObjectUtil.getFieldAnnotation(source, fieldName, CompareField.class);
        CompareField targetCompareField = ObjectUtil.getFieldAnnotation(target, fieldName, CompareField.class);
        if (sourceCompareField != null || targetCompareField != null) {
            List<DifferentField> ref = ObjectUtil.getDifferenceProperties(sourceValue, targetValue, new String[0]);
            return new DifferentRefField(fieldName, remark, Object.class, ref, sourceCompareField == null ? targetCompareField.ignoreParentName() : sourceCompareField.ignoreParentName(), sourceCompareField == null ? targetCompareField.ignoreParentRemark() : sourceCompareField.ignoreParentRemark());
        }
        if (source == null) {
            if (targetField.getType().isArray() || Collection.class.isAssignableFrom(targetField.getType())) {
                result = new DifferentCollectionField(fieldName, remark, targetField.getType());
                ((DifferentCollectionField)result).setAdd(ObjectUtil.to(targetValue, new TypeReference<List<Object>>(){}));
            } else {
                result = new DifferentSimpleField(fieldName, remark, targetField.getType());
                ((DifferentSimpleField)result).setNewValue(targetValue);
            }
        } else if (target == null) {
            if (sourceField.getType().isArray() || Collection.class.isAssignableFrom(sourceField.getType())) {
                result = new DifferentCollectionField(fieldName, remark, sourceField.getType());
                ((DifferentCollectionField)result).setAdd(ObjectUtil.to(sourceValue, new TypeReference<List<Object>>(){}));
            } else {
                result = new DifferentSimpleField(fieldName, remark, sourceField.getType());
                ((DifferentSimpleField)result).setNewValue(sourceValue);
            }
        } else if (targetValue == null) {
            if (sourceField != null && targetField != null && (sourceField.getType().isArray() || Collection.class.isAssignableFrom(sourceField.getType())) && (targetField.getType().isArray() || Collection.class.isAssignableFrom(targetField.getType()))) {
                result = new DifferentCollectionField(fieldName, remark, sourceField.getType());
                ((DifferentCollectionField)result).setDel(ObjectUtil.to(sourceValue, new TypeReference<List<Object>>(){}));
            } else {
                result = new DifferentSimpleField(fieldName, remark, sourceField.getType());
                ((DifferentSimpleField)result).setOldValue(sourceValue);
            }
        } else if (sourceValue == null) {
            if (sourceField != null && targetField != null && (sourceField.getType().isArray() || Collection.class.isAssignableFrom(sourceField.getType())) && (targetField.getType().isArray() || Collection.class.isAssignableFrom(targetField.getType()))) {
                result = new DifferentCollectionField(fieldName, remark, sourceField.getType());
                ((DifferentCollectionField)result).setAdd(ObjectUtil.to(targetValue, new TypeReference<List<Object>>(){}));
            } else {
                result = new DifferentSimpleField(fieldName, remark, targetField.getType());
                ((DifferentSimpleField)result).setNewValue(targetValue);
            }
        } else if ((sourceField.getType().isArray() || Collection.class.isAssignableFrom(sourceField.getType())) && (targetField.getType().isArray() || Collection.class.isAssignableFrom(targetField.getType()))) {
            List<Object> formatSourceValue = ObjectUtil.to(sourceValue, new TypeReference<List<Object>>(){});
            List<Object> formatTargetValue = ObjectUtil.to(targetValue, new TypeReference<List<Object>>(){});
            List<Object> add = formatTargetValue == null ? Lists.newArrayList() : formatTargetValue;
            List<Object> del = formatSourceValue == null ? Lists.newArrayList() : formatSourceValue;
            Iterator<Object> it = add.iterator();
            while (it.hasNext()) {
                Object node = it.next();
                if (!del.contains(node)) continue;
                del.remove(node);
                it.remove();
            }
            if (add.equals(del)) {
                return result;
            }
            result = new DifferentCollectionField(fieldName, remark, sourceField.getType());
            ((DifferentCollectionField)result).setAdd(add);
            ((DifferentCollectionField)result).setDel(del);
        } else {
            result = new DifferentSimpleField(fieldName, remark, sourceField.getType());
            ((DifferentSimpleField)result).setOldValue(sourceValue);
            ((DifferentSimpleField)result).setNewValue(targetValue);
        }
        return result;
    }

    public static <A extends Annotation> A getFieldAnnotation(Object object, String fieldName, Class<A> annotationClass) {
        if (object == null) {
            return null;
        }
        return ClassUtil.getFieldAnnotation(object.getClass(), fieldName, annotationClass);
    }

    private static String resolveLogField(Object source, Object target, String fieldName) throws DifferentField.LogFieldIgnoreException {
        boolean sourceFieldIgnore = false;
        boolean targetFieldIgnore = false;
        StringBuilder remark = new StringBuilder();
        Remark sourceLogField = ObjectUtil.getFieldAnnotation(source, fieldName, Remark.class);
        if (sourceLogField != null && !sourceLogField.ignoreCompare()) {
            remark.append(sourceLogField.value());
        } else if (sourceLogField != null) {
            sourceFieldIgnore = true;
        }
        Remark targetLogField = ObjectUtil.getFieldAnnotation(target, fieldName, Remark.class);
        if (targetLogField != null && !targetLogField.ignoreCompare() && !targetLogField.value().equals(remark.toString())) {
            if (remark.length() == 0) {
                remark.append(targetLogField.value());
            } else {
                remark.append("(").append(targetLogField.value()).append(")");
            }
        } else if (targetLogField != null) {
            targetFieldIgnore = true;
        }
        if (sourceFieldIgnore && targetFieldIgnore) {
            throw DifferentField.LogFieldIgnoreException.LOG_FIELD_IGNORE_EXCEPTION;
        }
        return remark.length() == 0 ? fieldName : remark.toString();
    }

    public static Field getField(Object object, String fieldName) {
        if (object == null) {
            return null;
        }
        return ClassUtil.getField(object.getClass(), fieldName);
    }

    public static boolean compareValue(Object source, Object target, String ... excludeProperty) {
        if (ObjectUtil.isEmpty((Object)source)) {
            return ObjectUtil.isEmpty((Object)target);
        }
        if (ObjectUtil.isEmpty((Object)target)) {
            return false;
        }
        List<DifferentField> list = ObjectUtil.getDifferenceProperties(source, target, excludeProperty);
        return ObjectUtils.isEmpty(list);
    }

    public static boolean compareOfNotNull(Object source, Object target) {
        Field[] fields;
        for (Field field : fields = source.getClass().getDeclaredFields()) {
            if (SERIAL_VERSION_UID.equals(field.getName())) continue;
            try {
                Object targetValue;
                Object sourceValue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                if ((sourceValue = field.get(source)) == null || sourceValue.equals(targetValue = field.get(target))) continue;
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public static enum ContainOrExclude {
        INCLUDE,
        EXCLUDE;

    }

    public static enum Compare {
        SAME,
        DIFF,
        DIFF_ALL_NOT_NULL,
        DIFF_SOURCE_NULL,
        DIFF_TARGET_NULL,
        DIFF_TARGET_DEFAULT,
        DIFF_SOURCE_NOT_NULL_AND_TARGET_DEFAULT,
        DIFF_SOURCE_NOT_NULL,
        DIFF_TARGET_NOT_NULL;

    }
}

