/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.object;

import cloud.agileframework.common.util.object.DifferentField;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DifferentSimpleField
extends DifferentField {
    private Object newValue;
    private Object oldValue;

    public DifferentSimpleField(String propertyName, String propertyRemark, Class<?> propertyType) {
        super(propertyName, propertyRemark, propertyType);
    }

    @Override
    public String describe() {
        Object oldValueTemp;
        StringBuilder desc = new StringBuilder(this.getFieldRemark() == null ? this.getFieldName() : this.getFieldRemark()).append(":");
        Object newValueTemp = this.newValue;
        if (newValueTemp instanceof String && StringUtils.isBlank((CharSequence)((String)newValueTemp))) {
            newValueTemp = null;
        }
        if ((oldValueTemp = this.oldValue) instanceof String && StringUtils.isBlank((CharSequence)((String)oldValueTemp))) {
            oldValueTemp = null;
        }
        if (!Objects.deepEquals(newValueTemp, oldValueTemp)) {
            if (oldValueTemp == null) {
                desc.append(String.format("\u8bbe\u7f6e\u6210\u4e86%s", newValueTemp));
            } else if (newValueTemp == null) {
                desc.append(String.format("%s\u88ab\u5220\u9664\u4e86", oldValueTemp));
            } else {
                desc.append(String.format("\u7531%s\u53d8\u6210%s", oldValueTemp, newValueTemp));
            }
        }
        return desc.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DifferentSimpleField)) {
            return false;
        }
        DifferentSimpleField other = (DifferentSimpleField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Object this$newValue = this.getNewValue();
        Object other$newValue = other.getNewValue();
        if (this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue)) {
            return false;
        }
        Object this$oldValue = this.getOldValue();
        Object other$oldValue = other.getOldValue();
        return !(this$oldValue == null ? other$oldValue != null : !this$oldValue.equals(other$oldValue));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DifferentSimpleField;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Object $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        Object $oldValue = this.getOldValue();
        result = result * 59 + ($oldValue == null ? 43 : $oldValue.hashCode());
        return result;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public void setNewValue(Object newValue) {
        this.newValue = newValue;
    }

    public void setOldValue(Object oldValue) {
        this.oldValue = oldValue;
    }

    @Override
    public String toString() {
        return "DifferentSimpleField(newValue=" + this.getNewValue() + ", oldValue=" + this.getOldValue() + ")";
    }

    public DifferentSimpleField() {
    }
}

