/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.ip;

import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.ip.IPv4Util;
import cloud.agileframework.common.util.object.ObjectUtil;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPSerializer
implements ObjectSerializer,
ObjectDeserializer {
    private static final Logger logger = LoggerFactory.getLogger(IPSerializer.class);

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        if (object == null) {
            return;
        }
        String ipLongString = String.valueOf(object);
        try {
            Long ipLong = NumberUtils.createLong((String)ipLongString);
            serializer.write(IPv4Util.longToIP(ipLong));
        }
        catch (Exception e) {
            logger.error(String.format("\u6570\u636e%s\u8f6c\u6362\u4e3aip\u65f6\u51fa\u73b0\u5f02\u5e38", ipLongString), (Throwable)e);
        }
    }

    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        String val = (String)parser.parse();
        return ObjectUtil.to((Object)IPv4Util.ipToLong(val), new TypeReference(type));
    }

    public int getFastMatchToken() {
        return 0;
    }
}

